/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityNuclearBoiler;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityReactorBoiler
extends TileEntityNuclearBoiler
implements SteamTile {
    public static final int WATER_PER_STEAM = 200;
    public static final int DETTEMP = 650;
    private WorkingFluid fluid = WorkingFluid.EMPTY;

    @Override
    public int getIndex() {
        return ReactorTiles.BOILER.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.temperature >= 650 && this.fluid == WorkingFluid.AMMONIA) {
            this.detonateAmmonia(world, x, y, z);
        }
        if (this.tank.getLevel() >= 200 && this.temperature > 100 && this.canBoilTankLiquid()) {
            ++this.steam;
            this.fluid = WorkingFluid.getWorkingFluid(this.tank.getActualFluid());
            if (this.fluid == WorkingFluid.AMMONIA) {
                ReactorAchievements.AMMONIA.triggerAchievement(this.getPlacer());
            }
            this.tank.removeLiquid(200);
            this.temperature -= 5;
        }
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(2500, FluidRegistry.WATER);
            this.temperature = 120;
        }
        if (this.steam <= 0) {
            this.fluid = WorkingFluid.EMPTY;
        }
        this.transferSteam(world, x, y, z);
    }

    private void detonateAmmonia(World world, int x, int y, int z) {
        ReactorAchievements.NH3EXPLODE.triggerAchievement(this.getPlacer());
        BlockArray pipes = new BlockArray();
        Block id = ReactorTiles.STEAMLINE.getBlock();
        int meta = ReactorTiles.STEAMLINE.getBlockMetadata();
        pipes.recursiveAddWithMetadata((IBlockAccess)world, x, y + 1, z, id, meta);
        for (int i = 0; i < pipes.getSize(); ++i) {
            Coordinate c = pipes.getNthBlock(i);
            c.setBlock(world, Blocks.field_150350_a);
            ReikaParticleHelper.EXPLODE.spawnAt(world, (double)c.xCoord, (double)c.yCoord, (double)c.zCoord);
            ReikaItemHelper.dropItem((World)world, (double)c.xCoord, (double)c.yCoord, (double)c.zCoord, (ItemStack)new ItemStack(Items.field_151130_bT));
        }
        world.func_147468_f(x, y, z);
        ReikaItemHelper.dropItem((World)world, (double)x, (double)y, (double)z, (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(8 + rand.nextInt(18))));
        ReikaParticleHelper.EXPLODE.spawnAt(world, (double)x, (double)y, (double)z);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)1.2f, (float)1.0f);
        boolean flag = false;
        int r = 8;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    Block id2 = world.func_147439_a(x + i, y + j, z + k);
                    int meta2 = world.func_72805_g(x + i, y + j, z + k);
                    if (id2 == Blocks.field_150350_a || id2.func_149688_o() != Material.field_151592_s) continue;
                    id2.func_149697_b(world, x + i, y + j, z + k, meta2, 0);
                    world.func_147468_f(x + i, y + j, z + k);
                    if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                        ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)id2, (int)meta2);
                    }
                    flag = true;
                }
            }
        }
        if (flag) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.glass");
        }
    }

    protected void transferSteam(World world, int x, int y, int z) {
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r == ReactorTiles.BOILER) {
            TileEntityReactorBoiler te = (TileEntityReactorBoiler)world.func_147438_o(x, y + 1, z);
            if (this.steam > 0 && this.fluid != WorkingFluid.EMPTY && (te.fluid == WorkingFluid.EMPTY || te.fluid == this.fluid)) {
                te.fluid = this.fluid;
                te.steam += this.steam;
                this.steam = 0;
            }
        }
    }

    private boolean canBoilTankLiquid() {
        if (WorkingFluid.getWorkingFluid(this.tank.getActualFluid()) == null) {
            return false;
        }
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (this.temperature < Tamb + 50) {
            return false;
        }
        return this.fluid == WorkingFluid.EMPTY || this.tank.getActualFluid().equals(this.fluid.getFluid());
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return WorkingFluid.getWorkingFluid(f) != null;
    }

    @Override
    public int getMaxTemperature() {
        return 2000;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.fluid = WorkingFluid.getFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.fluid.saveToNBT(NBT);
    }

    public WorkingFluid getWorkingFluid() {
        return this.fluid;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    protected void overheat(World world, int x, int y, int z) {
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 8.0f, true);
        for (int i = 0; i < 4; ++i) {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + rand.nextDouble()), (double)((double)y + rand.nextDouble()), (double)((double)z + rand.nextDouble()), (ItemStack)ItemStacks.scrap);
        }
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        EntityNeutron.NeutronType type = e.getType();
        if (!this.tank.isEmpty()) {
            if (this.tank.getActualFluid() == FluidRegistry.getFluid((String)"rc heavy water")) {
                e.moderate();
            } else if (e.getNeutronSpeed() == EntityNeutron.NeutronSpeed.FAST && rand.nextInt(10) == 0) {
                return true;
            }
            return ReikaRandomHelper.doWithChance((double)type.getBoilerAbsorptionChance());
        }
        return false;
    }

    @Override
    public int getSteam() {
        return this.steam;
    }
}

