/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorOres;
import java.util.ArrayList;
import java.util.HashSet;

public class ReactorConfig
extends ControlledConfig {
    private ControlledConfig.DataElement<Integer> potionID;
    private static final ArrayList<String> entries = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ReactorAchievements.class);
    private static final ArrayList<String> oreEntries = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ReactorOres.class);
    public ControlledConfig.DataElement<Integer>[] achievementIDs = new ControlledConfig.DataElement[entries.size()];
    private ControlledConfig.DataElement<Boolean>[] ores = new ControlledConfig.DataElement[entries.size()];
    private ControlledConfig.DataElement<int[]> heavyWaterDimensions;
    private HashSet<Integer> heavyWaterDimensionSet;

    public ReactorConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        super(mod, option, id);
        String name;
        int i;
        this.potionID = this.registerAdditionalOption("Other", "Radiation Effect ID", 140);
        for (i = 0; i < entries.size(); ++i) {
            name = entries.get(i);
            this.achievementIDs[i] = this.registerAdditionalOption("Achievement IDs", name, 72000 + i);
        }
        for (i = 0; i < oreEntries.size(); ++i) {
            name = oreEntries.get(i);
            this.ores[i] = this.registerAdditionalOption("Ore Control", name, true);
        }
        this.heavyWaterDimensions = this.registerAdditionalOption("Other Options", "Heavy Water Dimensions (Empty for All)", new int[0]);
    }

    public boolean isDimensionValidForHeavyWater(int dim) {
        if (this.heavyWaterDimensionSet == null) {
            this.heavyWaterDimensionSet = new HashSet();
            for (int val : (int[])this.heavyWaterDimensions.getData()) {
                this.heavyWaterDimensionSet.add(val);
            }
        }
        return this.heavyWaterDimensionSet.isEmpty() || this.heavyWaterDimensionSet.contains(dim);
    }

    public int getRadiationPotionID() {
        return (Integer)this.potionID.getData();
    }

    public boolean isOreGenEnabled(ReactorOres ore) {
        return (Boolean)this.ores[ore.ordinal()].getData();
    }
}

