/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.lib.compat.thaumcraft;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import theflogat.technomancy.common.items.base.TMItems;

public class ScepterRecipe
implements IArcaneRecipe {
    public boolean matches(IInventory inv, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)"TECHNOTURGESCEPTER")) {
            return false;
        }
        ItemStack cap1 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)0);
        ItemStack cap2 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)1);
        ItemStack cap3 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)2);
        ItemStack rod = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)1);
        ItemStack focus = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)0);
        if (ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)0) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)1) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)2) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)2) != null) {
            return false;
        }
        return ScepterRecipe.checkMatch(cap1, cap2, cap3, rod, focus, player);
    }

    private static boolean checkMatch(ItemStack cap1, ItemStack cap2, ItemStack cap3, ItemStack rod, ItemStack focus, EntityPlayer player) {
        boolean bc = false;
        boolean br = false;
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && ScepterRecipe.checkItemEquals(focus, new ItemStack(ConfigItems.itemResource, 1, 15)) && ScepterRecipe.checkItemEquals(cap1, cap2) && ScepterRecipe.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!ScepterRecipe.checkItemEquals(cap1, wc.getItem()) || !ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)wc.getResearch())) continue;
                bc = true;
                break;
            }
            if (rod.func_77973_b() == TMItems.itemWandCores && rod.func_77973_b().getDamage(rod) == 1) {
                br = true;
            }
        }
        return br && bc;
    }

    public ItemStack getCraftingResult(IInventory paramIInventory) {
        ItemStack out = null;
        String bc = null;
        String br = null;
        int cc = 0;
        int cr = 0;
        ItemStack cap1 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)1, (int)0);
        ItemStack cap2 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)2, (int)1);
        ItemStack cap3 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)0, (int)2);
        ItemStack rod = ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)1, (int)1);
        ItemStack focus = ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)2, (int)0);
        if (ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)0, (int)0) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)0, (int)1) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)1, (int)2) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)paramIInventory, (int)2, (int)2) != null) {
            return null;
        }
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && ScepterRecipe.checkItemEquals(focus, new ItemStack(ConfigItems.itemResource, 1, 15)) && ScepterRecipe.checkItemEquals(cap1, cap2) && ScepterRecipe.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!ScepterRecipe.checkItemEquals(cap1, wc.getItem())) continue;
                bc = wc.getTag();
                cc = wc.getCraftCost();
                break;
            }
            if (rod.func_77973_b() == TMItems.itemWandCores && rod.func_77973_b().getDamage(rod) == 1) {
                WandRod wr = (WandRod)WandRod.rods.get("technoturge");
                br = wr.getTag();
                cr = wr.getCraftCost();
            }
            if (bc != null && br != null) {
                int cost = (int)((float)(cc * cr) * 1.5f);
                out = new ItemStack(TMItems.itemTechnoturgeScepter, 1, cost);
                ((ItemWandCasting)out.func_77973_b()).setCap(out, (WandCap)WandCap.caps.get(bc));
                ((ItemWandCasting)out.func_77973_b()).setRod(out, (WandRod)WandRod.rods.get(br));
                out.func_77983_a("sceptre", (NBTBase)new NBTTagByte(1));
            }
        }
        return out;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public AspectList getAspects() {
        return null;
    }

    public AspectList getAspects(IInventory inv) {
        AspectList al = new AspectList();
        int cc = -1;
        int cr = -1;
        ItemStack cap1 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)0);
        ItemStack cap2 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)1);
        ItemStack cap3 = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)2);
        ItemStack rod = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)1);
        ItemStack focus = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)0);
        if (ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)0) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)0, (int)1) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)1, (int)2) != null || ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)2, (int)2) != null) {
            return al;
        }
        if (cap1 != null && cap2 != null && cap3 != null && rod != null && focus != null && ScepterRecipe.checkItemEquals(focus, new ItemStack(ConfigItems.itemResource, 1, 15)) && ScepterRecipe.checkItemEquals(cap1, cap2) && ScepterRecipe.checkItemEquals(cap1, cap3)) {
            for (WandCap wc : WandCap.caps.values()) {
                if (!ScepterRecipe.checkItemEquals(cap1, wc.getItem())) continue;
                cc = wc.getCraftCost();
                break;
            }
            for (WandRod wr : WandRod.rods.values()) {
                if (!ScepterRecipe.checkItemEquals(rod, wr.getItem())) continue;
                cr = wr.getCraftCost();
                break;
            }
            if (cc >= 0 && cr >= 0) {
                int cost = (int)((float)(cc * cr) * 1.5f);
                for (Aspect as : Aspect.getPrimalAspects()) {
                    al.add(as, cost);
                }
            }
        }
        return al;
    }

    public String getResearch() {
        return "";
    }

    private static boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && target.func_77960_j() == input.func_77960_j();
    }
}

