/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.lib.compat;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import theflogat.technomancy.Technomancy;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.blocks.botania.BlockManaFluid;
import theflogat.technomancy.common.blocks.botania.dynamos.BlockFlowerDynamo;
import theflogat.technomancy.common.blocks.botania.machines.BlockBOProcessor;
import theflogat.technomancy.common.blocks.botania.machines.BlockManaExchanger;
import theflogat.technomancy.common.blocks.botania.machines.BlockManaFabricator;
import theflogat.technomancy.common.items.base.TMItems;
import theflogat.technomancy.common.items.botania.ItemBOMaterial;
import theflogat.technomancy.common.items.botania.ItemManaBucket;
import theflogat.technomancy.common.items.botania.ItemManaExchanger;
import theflogat.technomancy.common.items.botania.ManaFluid;
import theflogat.technomancy.common.tiles.botania.dynamos.TileFlowerDynamo;
import theflogat.technomancy.common.tiles.botania.machines.TileBOProcessor;
import theflogat.technomancy.common.tiles.botania.machines.TileManaExchanger;
import theflogat.technomancy.common.tiles.botania.machines.TileManaFabricator;
import theflogat.technomancy.lib.Ids;
import theflogat.technomancy.lib.compat.ModuleBase;
import theflogat.technomancy.lib.compat.ThermalExpansion;
import theflogat.technomancy.lib.compat.botania.TechnoLexicon;
import theflogat.technomancy.lib.handlers.CompatibilityHandler;
import theflogat.technomancy.lib.handlers.CraftingHandler;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.recipe.RecipeManaInfusion;

public class Botania
extends ModuleBase {
    private static Botania instance;
    private static RecipeManaInfusion manaCoilRec;
    private static IRecipe manaGear;
    private static IRecipe flowerDynamo;
    private static IRecipe manaFabricator;
    private static IRecipe processorBO;
    private static IRecipe manaExchanger;

    private Botania() {
    }

    public static Botania getInstance() {
        if (instance == null) {
            instance = new Botania();
        }
        return instance;
    }

    public static void initBotaniaLexicon() {
        if (Ids.matBO) {
            TechnoLexicon manaCoilLex = new TechnoLexicon("tc.research_name.TECHNOBASICS", BotaniaAPI.categoryDevices);
            manaCoilLex.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("techno.research_page.TECHNOBASICS.1"), BotaniaAPI.internalHandler.manaInfusionRecipePage("Mana Coil", manaCoilRec), BotaniaAPI.internalHandler.craftingRecipePage("Manasteel Gear", manaGear)});
        }
        if (Ids.flowerDyn) {
            TechnoLexicon flowerDynLex = new TechnoLexicon("tc.research_name.DYNAMO", BotaniaAPI.categoryDevices);
            flowerDynLex.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("techno.lexicon_page.FLOWERDYNAMO.1"), BotaniaAPI.internalHandler.textPage("techno.lexicon_page.FLOWERDYNAMO.2"), BotaniaAPI.internalHandler.craftingRecipePage("Hippie Dynamo", flowerDynamo)});
            if (Ids.itemBoost) {
                flowerDynLex.addPage(BotaniaAPI.internalHandler.textPage("techno.lexicon_page.FLOWERDYNAMO.3"));
                flowerDynLex.addPage(BotaniaAPI.internalHandler.craftingRecipePage("Potency Gem", CraftingHandler.itemBoost));
            }
        }
        if (Ids.manaFab) {
            TechnoLexicon manaFabLex = new TechnoLexicon("techno.lexicon_name.MANAFAB", BotaniaAPI.categoryDevices);
            manaFabLex.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("techno.lexicon_page.MANAFAB.1"), BotaniaAPI.internalHandler.craftingRecipePage("Mana Fabricator", manaFabricator)});
        }
        if (Ids.processorBO) {
            TechnoLexicon processorBOLex = new TechnoLexicon("techno.lexicon_name.PROCESSORBO", BotaniaAPI.categoryDevices);
            processorBOLex.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("techno.lexicon_page.PROCESSORBO.1"), BotaniaAPI.internalHandler.textPage("techno.lexicon_page.PROCESSORBO.2"), BotaniaAPI.internalHandler.craftingRecipePage("Botanical Purifier", processorBO)});
        }
        if (Ids.manaExchanger) {
            TechnoLexicon manaExchangerLex = new TechnoLexicon("techno.lexicon_name.MANAEXCHANGER", BotaniaAPI.categoryDevices);
            manaExchangerLex.setLexiconPages(new LexiconPage[]{BotaniaAPI.internalHandler.textPage("techno.lexicon_page.MANAEXCHANGER.1"), BotaniaAPI.internalHandler.textPage("techno.lexicon_page.MANAEXCHANGER.2"), BotaniaAPI.internalHandler.craftingRecipePage("Mana Exchanger", manaExchanger)});
        }
    }

    public static void sparkle(World world, double d, double d1, double f, Random r) {
        BotaniaAPI.internalHandler.sparkleFX(world, d, d1, f, r.nextFloat(), r.nextFloat(), 1.0f, r.nextFloat() * 4.0f, 10);
    }

    @Override
    public void Init() {
        Technomancy.logger.info("Botania compatibility module loaded.");
    }

    @Override
    public void PostInit() {
        Botania.initBotaniaLexicon();
    }

    @Override
    public void RegisterItems() {
        TMItems.itemBO = Ids.matBO ? new ItemBOMaterial() : null;
        TMItems.manaBucket = Ids.manaFluid ? new ItemManaBucket(TMBlocks.manaFluidBlock) : null;
        this.registerItem(TMItems.itemBO, "itemBO");
        this.registerItem(TMItems.manaBucket, "manaBucket");
        this.registerBucket(TMBlocks.manaFluid, TMBlocks.manaFluidBlock, TMItems.manaBucket);
    }

    @Override
    public void RegisterBlocks() {
        TMBlocks.manaFluid = Ids.manaFluid ? new ManaFluid() : null;
        TMBlocks.manaFluidBlock = Ids.manaFluid ? new BlockManaFluid() : null;
        TMBlocks.flowerDynamo = Ids.flowerDyn ? new BlockFlowerDynamo() : null;
        TMBlocks.manaFabricator = Ids.manaFab ? new BlockManaFabricator() : null;
        TMBlocks.processorBO = Ids.processorBO ? new BlockBOProcessor() : null;
        TMBlocks.manaExchanger = Ids.manaExchanger ? new BlockManaExchanger() : null;
        Botania.registerBlock(TMBlocks.flowerDynamo, "flowerDynamo");
        Botania.registerBlock(TMBlocks.manaFabricator, "manaFabricator");
        Botania.registerBlock(TMBlocks.processorBO, "processorBO");
        Botania.registerBlock(TMBlocks.manaFluidBlock, "manaFluidBlock");
        this.registerBlock(TMBlocks.manaExchanger, "manaExchanger", ItemManaExchanger.class);
        this.registerTileEntity(TMBlocks.flowerDynamo, TileFlowerDynamo.class, "TileFlowerDynamo");
        this.registerTileEntity(TMBlocks.manaFabricator, TileManaFabricator.class, "ManaFabricator");
        this.registerTileEntity(TMBlocks.processorBO, TileBOProcessor.class, "TileProcessorBO");
        this.registerTileEntity(TMBlocks.manaExchanger, TileManaExchanger.class, "TileManaExchanger");
    }

    @Override
    public void RegisterRecipes() {
        if (CompatibilityHandler.te) {
            if (Ids.matBO) {
                manaCoilRec = BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(TMItems.itemBO, 1, 0), (Object)ThermalExpansion.powerCoilSilver, (int)3000);
            }
            if (Ids.matBO) {
                manaGear = this.oreDictRecipe(new ItemStack(TMItems.itemBO, 1, 1), new Object[]{" M ", "MIM", " M ", Character.valueOf('M'), "ingotManasteel", Character.valueOf('I'), "ingotIron"});
            }
            if (Ids.flowerDyn) {
                flowerDynamo = this.oreDictRecipe(new ItemStack(TMBlocks.flowerDynamo), new Object[]{" C ", "GIG", "IWI", Character.valueOf('W'), new ItemStack(Items.field_151137_ax), Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('G'), new ItemStack(TMItems.itemBO, 1, 1), Character.valueOf('I'), "ingotManasteel"});
            }
            if (Ids.manaFab) {
                manaFabricator = this.oreDictRecipe(new ItemStack(TMBlocks.manaFabricator), new Object[]{"CDC", "IDI", " P ", Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 1), Character.valueOf('I'), "ingotManasteel", Character.valueOf('D'), "manaDiamond", Character.valueOf('P'), ThermalExpansion.frameTesseractFull});
            }
            if (Ids.processorBO) {
                processorBO = this.oreDictRecipe(new ItemStack(TMBlocks.processorBO), new Object[]{" A ", "BMB", "ICI", Character.valueOf('M'), ThermalExpansion.frameMachineBasic, Character.valueOf('I'), "ingotManasteel", Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('B'), "livingrock", Character.valueOf('A'), new ItemStack(Items.field_151137_ax)});
            }
            if (Ids.manaExchanger) {
                manaExchanger = this.oreDictRecipe(new ItemStack(TMBlocks.manaExchanger), new Object[]{" A ", "BMB", "ICI", Character.valueOf('M'), ThermalExpansion.frameMachineBasic, Character.valueOf('I'), new ItemStack(ThermalExpansion.blockTank, 1, 3), Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('B'), "livingrock", Character.valueOf('A'), new ItemStack(GameRegistry.findItem((String)"Botania", (String)"pool"))});
            }
        } else {
            if (Ids.matBO) {
                manaCoilRec = BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(TMItems.itemBO, 1, 0), (Object)new ItemStack(Items.field_151137_ax), (int)3000);
            }
            if (Ids.matBO) {
                manaGear = this.oreDictRecipe(new ItemStack(TMItems.itemBO, 1, 1), new Object[]{" M ", "MIM", " M ", Character.valueOf('M'), "ingotManasteel", Character.valueOf('I'), "ingotIron"});
            }
            if (Ids.flowerDyn) {
                flowerDynamo = this.oreDictRecipe(new ItemStack(TMBlocks.flowerDynamo), new Object[]{" C ", "GIG", "IWI", Character.valueOf('W'), new ItemStack(Items.field_151137_ax), Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('G'), new ItemStack(TMItems.itemBO, 1, 1), Character.valueOf('I'), "ingotManasteel"});
            }
            if (Ids.manaFab) {
                manaFabricator = this.oreDictRecipe(new ItemStack(TMBlocks.manaFabricator), new Object[]{"CDC", "IDI", " P ", Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 1), Character.valueOf('I'), "ingotManasteel", Character.valueOf('D'), "manaDiamond", Character.valueOf('P'), new ItemStack(Items.field_151061_bv, 1, 0)});
            }
            if (Ids.processorBO) {
                processorBO = this.oreDictRecipe(new ItemStack(TMBlocks.processorBO), new Object[]{" A ", "BMB", "ICI", Character.valueOf('M'), new ItemStack(Items.field_151137_ax), Character.valueOf('I'), "ingotManasteel", Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('B'), "livingrock", Character.valueOf('A'), new ItemStack(Items.field_151137_ax)});
            }
            if (Ids.manaExchanger) {
                manaExchanger = this.oreDictRecipe(new ItemStack(TMBlocks.manaExchanger), new Object[]{"IAI", "BMB", "ICI", Character.valueOf('M'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150359_w)), Character.valueOf('I'), "ingotManasteel", Character.valueOf('C'), new ItemStack(TMItems.itemBO, 1, 0), Character.valueOf('B'), "livingrock", Character.valueOf('A'), new ItemStack(GameRegistry.findItem((String)"Botania", (String)"pool"))});
            }
        }
    }
}

