/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandable;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import thaumcraft.common.tiles.TileNode;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.tiles.air.TileFakeAirNG;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.IUpgradable;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileMachineRedstone;
import theflogat.technomancy.lib.compat.Thaumcraft;
import theflogat.technomancy.util.helpers.MathHelper;
import theflogat.technomancy.util.helpers.WorldHelper;

public class TileNodeGenerator
extends TileMachineRedstone
implements IEssentiaTransport,
IAspectContainer,
IWandable,
IUpgradable,
IWrenchable {
    private boolean regenDummyBlocks = true;
    private Aspect aspect;
    public int amount = 0;
    private int maxAmount = 256;
    public boolean active = false;
    private boolean canSpawn = false;
    private boolean addNode = false;
    public byte facing = (byte)2;
    public int rotation = 0;
    private boolean initiator = false;
    public boolean running = false;
    public int step = 0;
    public boolean boost = false;
    private static HashMap<Byte, double[][]> lightning = new HashMap();

    public TileNodeGenerator() {
        super(50000000, IRedstoneSensitive.RedstoneSet.LOW);
    }

    public void func_145845_h() {
        if (this.isWholeTileLoaded()) {
            if (this.regenDummyBlocks) {
                this.destroyDummyBlocks();
                this.createDummyBlocks();
                this.regenDummyBlocks = false;
            }
            if (!this.field_145850_b.field_72995_K) {
                TileNodeGenerator partner = TileNodeGenerator.getTE((IBlockAccess)this.field_145850_b, this.field_145851_c + ForgeDirection.getOrientation((int)this.facing).offsetX * 6, this.field_145848_d, this.field_145849_e + ForgeDirection.getOrientation((int)this.facing).offsetZ * 6);
                boolean bl = partner != null ? (partner.isWholeTileLoaded() ? ForgeDirection.getOrientation((int)this.facing).getOpposite() == ForgeDirection.getOrientation((int)partner.facing) : false) : (this.active = false);
                if (this.active) {
                    int xx = this.field_145851_c + ForgeDirection.getOrientation((int)this.facing).offsetX * 3;
                    int zz = this.field_145849_e + ForgeDirection.getOrientation((int)this.facing).offsetZ * 3;
                    TileEntity entity = this.field_145850_b.func_147438_o(xx, this.field_145848_d + 1, zz);
                    if (entity == null && this.field_145850_b.func_147437_c(xx, this.field_145848_d + 1, zz)) {
                        this.canSpawn = true;
                        this.addNode = false;
                    } else if (entity instanceof TileNode) {
                        INode node = (INode)entity;
                        this.addNode = true;
                        if (this.canRun() && !this.field_145850_b.field_72995_K && this.amount > 0 && this.aspect != null) {
                            if (this.getEnergyStored() >= 1000 && node.getAspects().aspects.containsKey(this.aspect) && node.getAspects().getAmount(this.aspect) < node.getAspectsBase().getAmount(this.aspect)) {
                                this.extractEnergy(1000, false);
                                node.addToContainer(this.aspect, 1);
                                this.takeFromContainer(this.aspect, 1);
                                this.field_145850_b.func_147471_g(xx, this.field_145848_d + 1, zz);
                            } else if (this.boost && this.getEnergyStored() >= 10000 && this.amount >= 10 && node.getNodeVisBase(this.aspect) < Short.MAX_VALUE) {
                                this.extractEnergy(10000, false);
                                node.setNodeVisBase(this.aspect, (short)(node.getNodeVisBase(this.aspect) + 1));
                                node.addToContainer(this.aspect, 1);
                                this.takeFromContainer(this.aspect, 10);
                                this.field_145850_b.func_147471_g(xx, this.field_145848_d + 1, zz);
                            }
                        }
                        this.initiator = false;
                        this.running = false;
                        this.canSpawn = false;
                        this.step = 0;
                    }
                    if (this.step == 200 && this.initiator) {
                        AspectList al = new AspectList();
                        al.add(this.aspect, this.amount);
                        al.add(partner.aspect, partner.amount);
                        this.generateNode(al);
                        this.takeFromContainer(this.aspect, this.amount);
                        partner.takeFromContainer(partner.aspect, partner.amount);
                        this.extractEnergy(MathHelper.round(Math.pow((this.amount + partner.amount) / 2, 2.0) * 762.939453125), false);
                        this.field_145850_b.func_147471_g(xx, this.field_145848_d + 1, zz);
                    }
                    this.fill();
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.active) {
                this.rotation += 1 + this.step / 5;
                if (this.rotation >= 360) {
                    this.rotation -= 360;
                }
                if (this.field_145850_b.field_73012_v.nextInt(Math.max(60 - this.step / 4, 1)) == 0) {
                    this.shootLightning();
                }
            }
            if (this.active) {
                if (this.running) {
                    ++this.step;
                }
            } else {
                this.initiator = false;
                this.running = false;
                this.addNode = false;
                this.canSpawn = false;
                this.step = 0;
            }
        }
    }

    private boolean isWholeTileLoaded() {
        for (int w = -1; w < 2; ++w) {
            if (!(this.facing == 2 || this.facing == 3 ? !WorldHelper.isChunkLoaded(this.field_145850_b, this.field_145851_c + w, this.field_145849_e) : !WorldHelper.isChunkLoaded(this.field_145850_b, this.field_145851_c, this.field_145849_e + w))) continue;
            return false;
        }
        return true;
    }

    private void createDummyBlocks() {
        for (int h = 0; h < 3; ++h) {
            for (int w = -1; w < 2; ++w) {
                if (h == 0 && w == 0) continue;
                if (this.facing == 2 || this.facing == 3) {
                    if (WorldHelper.destroyAndDrop(this.field_145850_b, this.field_145851_c + w, this.field_145848_d + h, this.field_145849_e)) {
                        this.field_145850_b.func_147449_b(this.field_145851_c + w, this.field_145848_d + h, this.field_145849_e, TMBlocks.fakeAirNG);
                        ((TileFakeAirNG)this.field_145850_b.func_147438_o(this.field_145851_c + w, this.field_145848_d + h, this.field_145849_e)).addMain(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        continue;
                    }
                    WorldHelper.destroyAndDrop(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    return;
                }
                if (WorldHelper.destroyAndDrop(this.field_145850_b, this.field_145851_c, this.field_145848_d + h, this.field_145849_e + w)) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + h, this.field_145849_e + w, TMBlocks.fakeAirNG);
                    ((TileFakeAirNG)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + h, this.field_145849_e + w)).addMain(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                WorldHelper.destroyAndDrop(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
        }
    }

    private void destroyDummyBlocks() {
        for (int h = 0; h < 3; ++h) {
            for (int w = -1; w < 2; ++w) {
                if (h == 0 && w == 0) continue;
                if (this.facing == 2 || this.facing == 3) {
                    this.field_145850_b.func_147468_f(this.field_145851_c + w, this.field_145848_d + h, this.field_145849_e);
                    continue;
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + h, this.field_145849_e + w);
            }
        }
    }

    void generateNode(AspectList aspects) {
        int xx = this.field_145851_c + ForgeDirection.getOrientation((int)this.facing).offsetX * 3;
        int zz = this.field_145849_e + ForgeDirection.getOrientation((int)this.facing).offsetZ * 3;
        if (this.field_145850_b.field_72995_K) {
            for (int a = 0; a < 6; ++a) {
                for (int b = 0; b < 6; ++b) {
                    float fx = (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.5f;
                    float fy = (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.5f;
                    float fz = (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.5f;
                    Thaumcraft.wispFX3(this.field_145850_b, (double)xx + 0.5 + (double)fx, (double)this.field_145848_d + 1.5 + (double)fy, (double)zz + 0.5 + (double)fz, (double)xx + 0.5 + (double)(fx * 10.0f), (double)this.field_145848_d + 1.5 + (double)(fy * 10.0f), (double)zz + 0.5 + (double)(fz * 10.0f), 0.4f, b, true, 0.05f);
                }
            }
            this.field_145850_b.func_72980_b((double)((float)xx + 0.5f), (double)this.field_145848_d + 1.5, (double)((float)zz + 0.5f), "thaumcraft:craftstart", 1.0f, 1.0f, false);
        } else {
            NodeType type = NodeType.NORMAL;
            NodeModifier mod = null;
            Aspect ra = null;
            int aurum = aspects.getAmount(Aspect.AURA);
            int taint = aspects.getAmount(Aspect.TAINT);
            ra = BiomeHandler.getRandomBiomeTag((int)this.field_145850_b.func_72807_a((int)xx, (int)zz).field_76756_M, (Random)this.field_145850_b.field_73012_v);
            if (ra == null) {
                ArrayList primals = Aspect.getPrimalAspects();
                ra = (Aspect)primals.get(this.field_145850_b.field_73012_v.nextInt(primals.size()));
            }
            if (aurum == taint && (aurum + taint == 122 || aurum + taint == 152 || aurum + taint == 218 || aurum + taint == 510)) {
                type = NodeType.PURE;
            } else if (aurum + taint > 256) {
                type = NodeType.HUNGRY;
            } else if (aurum - 64 > taint) {
                type = NodeType.UNSTABLE;
            } else if (taint - 64 > aurum) {
                type = taint > 96 ? NodeType.TAINTED : NodeType.DARK;
            }
            if (aurum + taint < 80) {
                mod = NodeModifier.FADING;
            } else if (aurum + taint > 200 && aurum + taint < 256 || aurum + taint == 510) {
                mod = NodeModifier.BRIGHT;
            } else if (aurum + taint > 350 && aurum + taint != 510) {
                mod = NodeModifier.PALE;
            }
            ThaumcraftWorldGenerator.createNodeAt((World)this.field_145850_b, (int)xx, (int)(this.field_145848_d + 1), (int)zz, (NodeType)type, (NodeModifier)mod, (AspectList)new AspectList().add(ra, (aurum + taint) / 2));
        }
    }

    void fill() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te;
            if (dir == ForgeDirection.getOrientation((int)this.facing) || (te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir)) == null) continue;
            IEssentiaTransport ic = (IEssentiaTransport)te;
            Aspect ta = ic.getEssentiaType(dir.getOpposite());
            if (ic.getEssentiaAmount(dir.getOpposite()) <= 0 || ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(null) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
            this.addToContainer(ta, ic.takeEssentia(ta, 1, dir.getOpposite()));
        }
    }

    void shootLightning() {
        double[] boltdata = lightning.get(this.facing)[this.field_145850_b.field_73012_v.nextInt(4)];
        FXLightningBolt bolt = new FXLightningBolt(this.field_145850_b, (double)this.field_145851_c + boltdata[0], (double)this.field_145848_d + boltdata[1], (double)this.field_145849_e + boltdata[2], (double)this.field_145851_c + boltdata[3], (double)this.field_145848_d + boltdata[4], (double)this.field_145849_e + boltdata[5], this.field_145850_b.field_73012_v.nextLong(), 6, 0.5f);
        bolt.defaultFractal();
        bolt.setType((int)boltdata[6]);
        bolt.setWidth(0.02f);
        bolt.finalizeBolt();
        this.field_145850_b.func_72980_b((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "thaumcraft:zap", 0.5f, this.field_145850_b.field_73012_v.nextFloat(), false);
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        int zz;
        int xx;
        TileNodeGenerator partner;
        if (this.canRun() && player != null && !player.func_70093_af() && world != null && this.active && this.canSpawn && !this.running && (partner = TileNodeGenerator.getTE((IBlockAccess)this.field_145850_b, xx = this.field_145851_c + ForgeDirection.getOrientation((int)this.facing).offsetX * 6, this.field_145848_d, zz = this.field_145849_e + ForgeDirection.getOrientation((int)this.facing).offsetZ * 6)) != null && this.amount + partner.amount > 64 && this.getEnergyStored() >= MathHelper.round(Math.pow((this.amount + partner.amount) / 2, 2.0) * 762.939453125)) {
            this.initiator = true;
            this.running = true;
            partner.running = true;
            this.step = 0;
            partner.step = 0;
            if (world.field_72995_K) {
                player.func_71038_i();
                world.func_72980_b((double)x, (double)y, (double)z, "thaumcraft:wand", 1.0f, 1.0f, false);
            }
            return 0;
        }
        return -1;
    }

    public ItemStack onWandRightClick(World world, ItemStack items, EntityPlayer player) {
        return items;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.facing == 1 || this.facing == 3) {
            return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 1.0f), (double)this.field_145848_d, (double)this.field_145849_e, (double)((float)this.field_145851_c + 2.0f), (double)((float)this.field_145848_d + 3.0f), (double)((float)this.field_145849_e + 1.0f));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)((float)this.field_145849_e - 1.0f), (double)((float)this.field_145851_c + 1.0f), (double)((float)this.field_145848_d + 3.0f), (double)((float)this.field_145849_e + 2.0f));
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        if (this.aspect != null) {
            compound.func_74778_a("Aspect", this.aspect.getTag());
        }
        compound.func_74777_a("Amount", (short)this.amount);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Spawn", this.canSpawn);
        compound.func_74774_a("Facing", this.facing);
        compound.func_74757_a("Running", this.running);
        compound.func_74757_a("Initiator", this.initiator);
        compound.func_74768_a("Step", this.step);
        compound.func_74757_a("Boost", this.boost);
        compound.func_74757_a("RegenDummyBlocks", this.regenDummyBlocks);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.aspect = Aspect.getAspect((String)compound.func_74779_i("Aspect"));
        this.amount = compound.func_74765_d("Amount");
        this.active = compound.func_74767_n("Active");
        this.canSpawn = compound.func_74767_n("Spawn");
        this.facing = compound.func_74771_c("Facing");
        this.running = compound.func_74767_n("Running");
        this.initiator = compound.func_74767_n("Initiator");
        this.step = compound.func_74762_e("Step");
        this.boost = compound.func_74767_n("Boost");
        this.regenDummyBlocks = compound.func_74767_n("RegenDummyBlocks");
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.aspect != null && this.amount > 0) {
            al.add(this.aspect, this.amount);
        }
        return al;
    }

    public int addToContainer(Aspect tag, int amt) {
        if (amt != 0 && (this.amount < this.maxAmount && tag == this.aspect || this.amount == 0)) {
            this.aspect = tag;
            int added = Math.min(amt, this.maxAmount - this.amount);
            this.amount += added;
            amt -= added;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return amt;
    }

    public boolean takeFromContainer(Aspect tag, int amt) {
        if (this.doesContainerContainAmount(tag, amt)) {
            this.amount -= amt;
            if (this.amount <= 0) {
                this.aspect = null;
                this.amount = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return this.amount >= amt && tag == this.aspect;
    }

    public int containerContains(Aspect tag) {
        return this.aspect == tag ? this.amount : 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canOutputTo(ForgeDirection face) {
        return face != ForgeDirection.getOrientation((int)this.facing);
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int getMinimumSuction() {
        return 32;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        if (!this.addNode && this.active) {
            if (this.facing == 2 || this.facing == 4) {
                return tag == Aspect.AURA && this.amount < this.maxAmount;
            }
            return tag == Aspect.TAINT && this.amount < this.maxAmount;
        }
        return this.aspect == null ? true : this.aspect == tag && this.amount < this.maxAmount;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        if (this.aspect != null) {
            return this.aspect;
        }
        if (!this.addNode && this.active) {
            if (this.facing == 2 || this.facing == 4) {
                return Aspect.AURA;
            }
            return Aspect.TAINT;
        }
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.amount < this.maxAmount ? 48 : 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return amount - this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.aspect;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return this.aspect != null && this.amount > 0 && ot.size() == 1 && ot.getAspects()[0] == this.aspect && ot.getAmount(this.aspect) <= this.amount;
    }

    @Override
    public boolean toggleBoost() {
        this.boost = !this.boost;
        return this.boost;
    }

    @Override
    public boolean getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(boolean newBoost) {
        this.boost = newBoost;
    }

    private static TileNodeGenerator getTE(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TileNodeGenerator ? (TileNodeGenerator)tile : null;
    }

    public boolean canRun() {
        boolean state = true;
        for (int h = 0; h < 3 && state; ++h) {
            for (int w = -1; w < 2 && state; ++w) {
                state = this.facing == 2 || this.facing == 3 ? this.set.canRun(this.field_145850_b, this.field_145851_c + w, this.field_145848_d + h, this.field_145849_e) : this.set.canRun(this.field_145850_b, this.field_145851_c, this.field_145848_d + h, this.field_145849_e + w);
            }
        }
        return state;
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        if (sneaking) {
            this.destroyDummyBlocks();
            if (!this.field_145850_b.field_72995_K) {
                this.facing = (byte)(this.facing == 5 ? 2 : this.facing + 1);
                this.regenDummyBlocks = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return false;
    }

    @Override
    public String getInfo() {
        return "Add Apsects And Increase Vis";
    }

    static {
        lightning.put((byte)2, new double[][]{{1.5, 2.5, -0.5, -0.5, 0.5, -4.5, 0.0}, {-0.5, 2.5, -0.5, 1.5, 0.5, -4.5, 0.0}, {1.5, 0.5, -0.5, -0.5, 2.5, -4.5, 0.0}, {-0.5, 0.5, -0.5, 1.5, 2.5, -4.5, 0.0}});
        lightning.put((byte)3, new double[][]{{-0.5, 2.5, 1.5, 1.5, 0.5, 5.5, 5.0}, {1.5, 2.5, 1.5, -0.5, 0.5, 5.5, 5.0}, {1.5, 0.5, 1.5, -0.5, 2.5, 5.5, 5.0}, {-0.5, 0.5, 1.5, 1.5, 2.5, 5.5, 5.0}});
        lightning.put((byte)4, new double[][]{{-0.5, 2.5, 1.5, -4.5, 0.5, -0.5, 0.0}, {-0.5, 2.5, -0.5, -4.5, 0.5, 1.5, 0.0}, {-0.5, 0.5, 1.5, -4.5, 2.5, -0.5, 0.0}, {-0.5, 0.5, -0.5, -4.5, 2.5, 1.5, 0.0}});
        lightning.put((byte)5, new double[][]{{1.5, 2.5, -0.5, 5.5, 0.5, 1.5, 5.0}, {1.5, 2.5, 1.5, 5.5, 0.5, -0.5, 5.0}, {1.5, 0.5, 1.5, 5.5, 2.5, -0.5, 5.0}, {1.5, 0.5, -0.5, 5.5, 2.5, 1.5, 5.0}});
    }
}

