/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.common.Optional;
import java.util.HashMap;
import me.jezza.thaumicpipes.api.interfaces.IThaumicOutput;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import theflogat.technomancy.common.blocks.thaumcraft.machines.BlockCondenser;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileMachineRedstone;
import theflogat.technomancy.lib.compat.Thaumcraft;
import theflogat.technomancy.lib.handlers.Rate;

@Optional.Interface(iface="me.jezza.thaumicpipes.api.interfaces.IThaumicOutput", modid="ThaumicPipes")
public class TileCondenser
extends TileMachineRedstone
implements IEssentiaTransport,
IAspectSource,
IWrenchable,
IThaumicOutput {
    public static final Aspect aspect = Aspect.ENERGY;
    public HashMap<ForgeDirection, Boolean> sides = new HashMap();
    public int amount = 0;
    public static final int maxAmount = 64;
    public static int cost = Rate.condenserCost;

    public TileCondenser() {
        super(Rate.condenserCost * 5, IRedstoneSensitive.RedstoneSet.LOW);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sides.put(dir, false);
        }
    }

    public void func_145845_h() {
        if (this.set.canRun(this) && this.energy >= cost && this.amount < 64) {
            this.extractEnergy(cost, false);
            ++this.amount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.amount > 0) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IEssentiaTransport te;
                if (!this.sides.get(dir).booleanValue() || (te = (IEssentiaTransport)Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir)) == null || !te.canInputFrom(dir)) continue;
                this.amount = te.addEssentia(aspect, this.amount, dir);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        compound.func_74777_a("Amount", (short)this.amount);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NBTTagCompound side = new NBTTagCompound();
            side.func_74757_a("s", this.sides.get(dir).booleanValue());
            compound.func_74782_a(dir.name(), (NBTBase)side);
        }
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.amount = compound.func_74765_d("Amount");
        this.sides.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NBTTagCompound side = compound.func_74775_l(dir.name());
            this.sides.put(dir, side.func_74767_n("s"));
        }
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.amount > 0) {
            al.add(aspect, this.amount);
        }
        return al;
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (tag == aspect && amount <= this.amount) {
            this.amount -= amount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        if (ot.getAspects().length == 1 && ot.getAspects()[0] == aspect && ot.getAmount(aspect) <= this.amount) {
            this.amount -= ot.getAmount(aspect);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return tag == aspect && amt <= this.amount;
    }

    public int containerContains(Aspect tag) {
        return tag == aspect ? this.amount : 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return this.sides.get(face);
    }

    public boolean canInputFrom(ForgeDirection face) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return this.sides.get(face);
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return tag == aspect;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return aspect;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.isConnectable(face) ? this.amount : 0;
    }

    public boolean doesContainerContain(AspectList ot) {
        return ot.getAspects().length == 1 && ot.getAspects()[0] == aspect && this.amount > 0;
    }

    public boolean toggleDir(int side) {
        if (side != BlockCondenser.getFacingFromMeta(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            boolean b = this.sides.get(ForgeDirection.VALID_DIRECTIONS[side]);
            this.sides.put(ForgeDirection.VALID_DIRECTIONS[side], !b);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ++this.field_145847_g;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g >= 4 ? 0 : this.field_145847_g, 2);
        return false;
    }
}

