/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import theflogat.technomancy.common.tiles.base.IUpgradable;
import theflogat.technomancy.common.tiles.base.TileTechnomancy;
import theflogat.technomancy.lib.compat.Thaumcraft;

public class TileAdvDeconTable
extends TileTechnomancy
implements IInventory,
IUpgradable {
    public int breakSpeed = 80;
    public Aspect aspect;
    public int breaktime;
    private ItemStack[] items = new ItemStack[1];
    public String owner = "";

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        if (!this.owner.equals("")) {
            comp.func_74778_a("owner", this.owner);
        }
        if (this.aspect != null) {
            comp.func_74778_a("Aspect", this.aspect.getTag());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound stack = new NBTTagCompound();
            stack.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(stack);
            list.func_74742_a((NBTBase)stack);
        }
        comp.func_74782_a("Items", (NBTBase)list);
        comp.func_74768_a("breakspeed", this.breakSpeed);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        this.owner = comp.func_74779_i("owner");
        this.aspect = Aspect.getAspect((String)comp.func_74779_i("Aspect"));
        NBTTagList list = comp.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stack = list.func_150305_b(i);
            byte slot = stack.func_74771_c("Slot");
            if (slot < 0 || slot >= this.items.length) continue;
            this.items[slot] = ItemStack.func_77949_a((NBTTagCompound)stack);
        }
        this.breakSpeed = comp.func_74762_e("breakspeed");
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.items[i] != null) {
            if (this.items[i].field_77994_a <= j) {
                ItemStack itemstack = this.items[i];
                this.items[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[i].func_77979_a(j);
            if (this.items[i].field_77994_a == 0) {
                this.items[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack it = this.items[i].func_77946_l();
        this.items[i] = null;
        return it;
    }

    public void func_70299_a(int i, ItemStack it) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.items[i] = it;
    }

    public String func_145825_b() {
        return "AdvDeconTable";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack j) {
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)j);
        return (al = ThaumcraftCraftingManager.getBonusTags((ItemStack)j, (AspectList)al)) != null && al.size() != 0;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        short curr;
        boolean update = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.breaktime == 0 && this.canBreak()) {
                this.breaktime = this.breakSpeed;
                update = true;
            }
            if (this.breaktime > 0 && this.canBreak()) {
                --this.breaktime;
                if (this.breaktime == 0) {
                    this.breakItem();
                    update = true;
                }
            } else {
                this.breaktime = 0;
            }
        }
        if (this.field_145850_b.func_72820_D() % 20L == 0L && this.aspect != null && (curr = Thaumcraft.getAspectPoolFor(this.owner, this.aspect)) < Short.MAX_VALUE) {
            curr = (short)(curr + 1);
            Thaumcraft.addAspectsToPool(this.owner, this.aspect, curr);
            this.aspect = null;
        }
        if (update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean canBreak() {
        if (this.items[0] == null || this.aspect != null) {
            return false;
        }
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)this.items[0]);
        return (al = ThaumcraftCraftingManager.getBonusTags((ItemStack)this.items[0], (AspectList)al)) != null && al.size() != 0;
    }

    private void breakItem() {
        if (this.canBreak()) {
            AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)this.items[0]);
            al = ThaumcraftCraftingManager.getBonusTags((ItemStack)this.items[0], (AspectList)al);
            AspectList primals = TileAdvDeconTable.reduceToPrimals(al);
            if (this.field_145850_b.field_73012_v.nextInt(80) < primals.visSize() && this.field_145850_b.field_73012_v.nextInt(8) == 0) {
                this.aspect = primals.getAspects()[this.field_145850_b.field_73012_v.nextInt(primals.getAspects().length)];
            }
            --this.items[0].field_77994_a;
            if (this.items[0].field_77994_a <= 0) {
                this.items[0] = null;
            }
        }
    }

    public static AspectList reduceToPrimals(AspectList al) {
        AspectList out = new AspectList();
        for (Aspect aspect : al.getAspects()) {
            if (aspect == null) continue;
            if (aspect.isPrimal()) {
                out.add(aspect, al.getAmount(aspect));
                continue;
            }
            AspectList send = new AspectList();
            send.add(aspect.getComponents()[0], al.getAmount(aspect));
            send.add(aspect.getComponents()[1], al.getAmount(aspect));
            send = TileAdvDeconTable.reduceToPrimals(send);
            for (Aspect a : send.getAspects()) {
                out.add(a, send.getAmount(a));
            }
        }
        return out;
    }

    @Override
    public boolean toggleBoost() {
        this.breakSpeed = this.getBoost() ? 80 : 40;
        return this.getBoost();
    }

    @Override
    public boolean getBoost() {
        return this.breakSpeed == 40;
    }

    @Override
    public void setBoost(boolean newBoost) {
        this.breakSpeed = newBoost ? 40 : 80;
    }

    @Override
    public String getInfo() {
        return "Twice the fastness";
    }
}

