/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.technom.existence;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.TileTechnomancyRedstone;
import theflogat.technomancy.common.tiles.technom.existence.IExistenceConsumer;
import theflogat.technomancy.common.tiles.technom.existence.IExistenceProducer;
import theflogat.technomancy.common.tiles.technom.existence.IExistenceTransmitter;

public class TileExistencePylon
extends TileTechnomancyRedstone
implements IExistenceTransmitter {
    public Type transferRate;
    public int power;

    public TileExistencePylon() {
        super(IRedstoneSensitive.RedstoneSet.LOW);
    }

    public void func_145845_h() {
        if (this.transferRate == null) {
            this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.transferRate = Type.getTypeFromId(this.field_145847_g);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.power < this.transferRate.tRate) {
            this.input();
        }
        if (this.power > 0) {
            this.output();
            if (this.power > 0) {
                this.transfert();
            }
        }
    }

    private void input() {
        for (int xx = -7; xx <= 7; ++xx) {
            for (int zz = -7; zz <= 7; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    int t;
                    IExistenceProducer ex;
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    if (te == null || !(te instanceof IExistenceProducer) || te instanceof TileExistencePylon || !(ex = (IExistenceProducer)te).canOutput() || (t = Math.min(this.transferRate.tRate - this.power, Math.min(ex.getMaxRate(), ex.getPower()))) <= 0) continue;
                    ex.addPower(-t);
                    this.power += t;
                }
            }
        }
    }

    private void transfert() {
        for (int xx = -7; xx <= 7; ++xx) {
            for (int zz = -7; zz <= 7; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    TileExistencePylon ex;
                    int t;
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    if (te == null || !(te instanceof TileExistencePylon) || (t = Math.min(this.power, Math.min((ex = (TileExistencePylon)te).getMaxRate(), ex.getPowerCap() - ex.getPower()))) <= 0) continue;
                    ex.addPower(t);
                    this.power -= t;
                }
            }
        }
    }

    private void output() {
        for (int xx = -7; xx <= 7; ++xx) {
            for (int zz = -7; zz <= 7; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    int t;
                    IExistenceConsumer ex;
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    if (te == null || !(te instanceof IExistenceConsumer) || !(ex = (IExistenceConsumer)te).canInput() || (t = Math.min(this.power, Math.min(ex.getMaxRate(), ex.getPowerCap() - ex.getPower()))) <= 0) continue;
                    ex.addPower(t);
                    this.power -= t;
                }
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
        this.set.save(comp);
        comp.func_74768_a("power", this.power);
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
        this.set = IRedstoneSensitive.RedstoneSet.load(comp);
        this.power = comp.func_74762_e("power");
    }

    @Override
    public int getMaxRate() {
        if (this.transferRate == null) {
            this.transferRate = Type.getTypeFromId(this.field_145847_g);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.transferRate.tRate;
    }

    public int getPower() {
        return this.power;
    }

    public int getPowerCap() {
        if (this.transferRate == null) {
            this.transferRate = Type.getTypeFromId(this.field_145847_g);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.transferRate.tRate;
    }

    public void addPower(int val) {
        this.power += val;
    }

    public static enum Type {
        BASIC(5, 0),
        ADVANCED(25, 1),
        COMPLEX(125, 2);

        public int id;
        public int tRate;
        public static final Type[] allTypes;

        private Type(int tRate, int id) {
            this.tRate = tRate;
            this.id = id;
        }

        public static Type getTypeFromId(int id) {
            for (Type t : allTypes) {
                if (t.id != id) continue;
                return t;
            }
            return BASIC;
        }

        static {
            allTypes = new Type[]{BASIC, ADVANCED, COMPLEX};
        }
    }
}

