/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.bloodmagic.machines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import theflogat.technomancy.common.tiles.base.TileMachineBase;
import theflogat.technomancy.lib.compat.BloodMagic;
import theflogat.technomancy.lib.handlers.Rate;
import theflogat.technomancy.util.helpers.WorldHelper;

public class TileBloodFabricator
extends TileMachineBase
implements IFluidHandler {
    public FluidTank tank = new FluidTank(10000);
    public static int cost = Rate.bloodFabCost;
    int count = 0;

    public TileBloodFabricator() {
        super(Rate.bloodFabCost * 50);
    }

    public void func_145845_h() {
        if (this.getEnergyStored() >= cost && this.tank.getFluidAmount() + 200 <= this.tank.getCapacity()) {
            this.extractEnergy(cost, false);
            this.tank.fill(new FluidStack(BloodMagic.lifeEssenceFluid, 200), true);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.tank.getFluidAmount() >= 200) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IFluidHandler target;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (!(te instanceof IFluidHandler) || !(target = (IFluidHandler)te).canFill(dir.getOpposite(), BloodMagic.lifeEssenceFluid)) continue;
                FluidStack push = this.tank.getFluid().copy();
                push.amount = Math.min(push.amount, 200);
                int filled = target.fill(dir.getOpposite(), push, true);
                if (filled <= 0) continue;
                this.tank.drain(filled, true);
                return;
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from != ForgeDirection.UNKNOWN) {
            return 0;
        }
        if (resource.getFluid() == BloodMagic.lifeEssenceFluid) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.tank.getFluid() != null) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)200);
        int f = WorldHelper.insertFluidIntoAdjacentFluidHandler(this, from.ordinal(), stack, false);
        return f == 200;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.tank = new FluidTank(10000);
        this.tank.readFromNBT(compound);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }
}

