/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.base;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import theflogat.technomancy.common.blocks.base.BlockContainerRedstone;
import theflogat.technomancy.common.tiles.base.ICouplable;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.IUpgradable;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileTechnomancyRedstone;
import theflogat.technomancy.util.helpers.WorldHelper;

public abstract class TileCoilTransmitter
extends TileTechnomancyRedstone
implements ICouplable,
IWrenchable,
IUpgradable {
    public boolean redstoneState = false;
    public ArrayList<ChunkCoordinates> sources = new ArrayList();
    public int facing = 0;
    public boolean boost;

    public TileCoilTransmitter() {
        super(IRedstoneSensitive.RedstoneSet.LOW);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
        int sourceCount = 0;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get(i) == null) continue;
            comp.func_74768_a("xcoord" + sourceCount, this.sources.get((int)i).field_71574_a);
            comp.func_74768_a("ycoord" + sourceCount, this.sources.get((int)i).field_71572_b);
            comp.func_74768_a("zcoord" + sourceCount, this.sources.get((int)i).field_71573_c);
            ++sourceCount;
        }
        comp.func_74768_a("size", sourceCount);
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
        int size = comp.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            int xx = comp.func_74762_e("xcoord" + i);
            int yy = comp.func_74762_e("ycoord" + i);
            int zz = comp.func_74762_e("zcoord" + i);
            this.sources.add(new ChunkCoordinates(xx, yy, zz));
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74774_a("facing", (byte)this.facing);
        comp.func_74757_a("boost", this.boost);
        comp.func_74757_a("redstone", this.redstoneState);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.facing = comp.func_74771_c("facing");
        this.boost = comp.func_74767_n("boost");
        this.redstoneState = comp.func_74767_n("redstone");
    }

    @Override
    public void addPos(ChunkCoordinates coords) {
        this.sources.add(coords);
    }

    @Override
    public void clear() {
        this.sources.clear();
    }

    @Override
    public boolean toggleBoost() {
        this.boost = !this.boost;
        this.fixRedstone();
        return this.boost;
    }

    @Override
    public boolean getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(boolean newBoost) {
        this.boost = newBoost;
        this.fixRedstone();
    }

    @Override
    public boolean canBeModified() {
        return !this.boost;
    }

    private void fixRedstone() {
        if (this.boost) {
            if (this.modified) {
                if (!this.field_145850_b.field_72995_K) {
                    Item it = BlockContainerRedstone.settingToItem.get((Object)this.set);
                    WorldHelper.spawnEntItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(it, 1));
                }
                this.modified = false;
            }
            this.set = IRedstoneSensitive.RedstoneSet.NONE;
        } else {
            this.set = IRedstoneSensitive.RedstoneSet.LOW;
        }
    }

    @Override
    public String getInfo() {
        return "Emits A Redstone Signal When Not Full";
    }
}

