/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.rituals;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import tombenpotter.sanguimancy.util.RitualUtils;

public class RitualEffectPump
extends RitualEffect {
    public static final int reagentDrain = 5;

    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
        World world = ritualStone.getWorld();
        if (world.func_72820_D() % 10L != 5L) {
            return;
        }
        int x = ritualStone.getXCoord();
        TileEntity tile = world.func_147438_o(x, (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        IFluidHandler tileEntity = (IFluidHandler)tile;
        boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 5, true);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 5, true);
        if (currentEssence < this.getCostPerRefresh()) {
            EntityPlayer entityOwner = SpellHelper.getPlayerForUsername((String)owner);
            if (entityOwner == null) {
                return;
            }
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
        } else {
            for (int i = 0; i < 6; ++i) {
                SpellHelper.sendIndexedParticleToAllAround((World)world, (double)x, (double)y, (double)z, (int)20, (int)world.field_73011_w.field_76574_g, (int)3, (double)x, (double)y, (double)z);
            }
            if (tileEntity.drain(ForgeDirection.UNKNOWN, 1000, false) != null) {
                ArrayList<Object> pumpables = new ArrayList();
                FluidStack fluid = tileEntity.drain(ForgeDirection.UNKNOWN, 1000, false);
                int rangeMultiplier = RitualUtils.getRangeMultiplier(hasTerrae, hasOrbisTerrae);
                if (pumpables.isEmpty()) {
                    pumpables = RitualUtils.PumpUtils.getPumpablesInArea(world, fluid, x, y, z, rangeMultiplier);
                }
                for (Int3 int3 : pumpables) {
                    if (world.field_73012_v.nextInt(pumpables.size()) != 0) continue;
                    tileEntity.fill(ForgeDirection.DOWN, fluid, true);
                    SoulNetworkHandler.syphonFromNetwork((String)owner, (int)this.getCostPerRefresh());
                    world.func_147449_b(int3.xCoord, int3.yCoord, int3.zCoord, Blocks.field_150348_b);
                    SoulNetworkHandler.syphonFromNetwork((String)owner, (int)this.getCostPerRefresh());
                }
                pumpables.clear();
            }
        }
    }

    public int getCostPerRefresh() {
        return 20;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> pumpRitual = new ArrayList<RitualComponent>();
        pumpRitual.add(new RitualComponent(1, 0, 1, 1));
        pumpRitual.add(new RitualComponent(-1, 0, 1, 2));
        pumpRitual.add(new RitualComponent(1, 0, -1, 3));
        pumpRitual.add(new RitualComponent(-1, 0, -1, 4));
        pumpRitual.add(new RitualComponent(1, -1, 1, 5));
        pumpRitual.add(new RitualComponent(-1, -1, 1, 5));
        pumpRitual.add(new RitualComponent(1, -1, -1, 5));
        pumpRitual.add(new RitualComponent(-1, -1, -1, 5));
        return pumpRitual;
    }
}

