/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.api.tile;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tombenpotter.sanguimancy.api.objects.BlockPostition;
import tombenpotter.sanguimancy.api.objects.BoolAndBlockPosList;
import tombenpotter.sanguimancy.api.objects.ICustomNBTTag;
import tombenpotter.sanguimancy.api.objects.SNKNotBoolean;
import tombenpotter.sanguimancy.api.snManifestation.ISNComponent;
import tombenpotter.sanguimancy.api.snManifestation.ISNKnot;
import tombenpotter.sanguimancy.api.snManifestation.ISNPart;

public abstract class TileBaseSNPart
extends TileEntity
implements ISNPart,
ICustomNBTTag {
    @Override
    public ArrayList<BlockPostition> getSNKnots() {
        ArrayList<BlockPostition> list = new ArrayList<BlockPostition>();
        HashMap<BlockPostition, SNKNotBoolean> map = this.getComponentsInNetwork().hashMap;
        for (BlockPostition postition : map.keySet()) {
            if (!map.get((Object)postition).isSNKnotActive || !map.get((Object)postition).isSNKnot) continue;
            list.add(postition);
        }
        return list;
    }

    @Override
    public BoolAndBlockPosList getComponentsInNetwork() {
        BoolAndBlockPosList blockPosList = new BoolAndBlockPosList();
        if (this.getAdjacentISNComponents() != null) {
            for (BlockPostition postition : this.getAdjacentISNComponents()) {
                if (postition == null) continue;
                if (!blockPosList.hashMap.containsKey(postition) && postition.getTile(this.field_145850_b) != null && postition.getTile(this.field_145850_b) instanceof ISNKnot) {
                    ISNKnot knot = (ISNKnot)postition.getTile(this.field_145850_b);
                    blockPosList.hashMap.put(postition, new SNKNotBoolean(knot.isSNKnot(), knot.isSNKnotactive()));
                    continue;
                }
                if (blockPosList.hashMap.containsKey(postition) || postition.getTile(this.field_145850_b) == null || !(postition.getTile(this.field_145850_b) instanceof ISNComponent)) continue;
                ISNComponent component = (ISNComponent)postition.getTile(this.field_145850_b);
                blockPosList.hashMap.put(postition, new SNKNotBoolean(component.isSNKnot(), false));
                component.getAdjacentComponents(new BlockPostition(this.field_145851_c, this.field_145848_d, this.field_145849_e), blockPosList);
            }
        }
        return blockPosList;
    }

    @Override
    public BoolAndBlockPosList getAdjacentComponents(BlockPostition originalPosition, BoolAndBlockPosList blockPosList) {
        for (BlockPostition postition : this.getAdjacentISNComponents()) {
            if (postition == null) continue;
            if (!blockPosList.hashMap.containsKey(postition) && postition.getTile(this.field_145850_b) != null && postition.getTile(this.field_145850_b) instanceof ISNKnot) {
                ISNKnot knot = (ISNKnot)postition.getTile(this.field_145850_b);
                blockPosList.hashMap.put(postition, new SNKNotBoolean(knot.isSNKnot(), knot.isSNKnotactive()));
                continue;
            }
            if (blockPosList.hashMap.containsKey(postition) || postition.getTile(this.field_145850_b) == null || !(postition.getTile(this.field_145850_b) instanceof ISNComponent)) continue;
            ISNComponent component = (ISNComponent)postition.getTile(this.field_145850_b);
            blockPosList.hashMap.put(postition, new SNKNotBoolean(component.isSNKnot(), false));
            component.getAdjacentComponents(new BlockPostition(this.field_145851_c, this.field_145848_d, this.field_145849_e), blockPosList);
        }
        return blockPosList;
    }

    @Override
    public BlockPostition[] getAdjacentISNComponents() {
        int i = 0;
        BlockPostition[] adjacentBranches = new BlockPostition[6];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            adjacentBranches[i] = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) != null && this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) instanceof ISNComponent ? new BlockPostition(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) : null;
            ++i;
        }
        return adjacentBranches;
    }
}

