/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils;

import net.minecraftforge.common.util.ForgeDirection;

public enum Sides {
    BOTTOM("bottom"),
    TOP("top"),
    BACK("back"),
    FRONT("front"),
    RIGHT("right"),
    LEFT("left");

    public String name;
    public static final ForgeDirection[][] neighborsBySide;

    private Sides(String name) {
        this.name = name;
    }

    public ForgeDirection getForgeDirection(ForgeDirection front) {
        switch (this) {
            case BACK: {
                return ForgeDirection.getOrientation((int)front.ordinal()).getOpposite();
            }
            case FRONT: {
                return ForgeDirection.getOrientation((int)front.ordinal());
            }
            case RIGHT: {
                return ForgeDirection.getOrientation((int)(front.ordinal() % 5 + 2));
            }
            case LEFT: {
                return ForgeDirection.getOrientation((int)(front.ordinal() % 5 + 2)).getOpposite();
            }
            case TOP: 
            case BOTTOM: {
                return ForgeDirection.getOrientation((int)this.ordinal());
            }
        }
        return front;
    }

    static {
        neighborsBySide = new ForgeDirection[][]{{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.NORTH}};
    }
}

