/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.simpledhd.tileentity;

import java.util.LinkedList;
import lordfokas.stargatetech2.api.StargateTechAPI;
import lordfokas.stargatetech2.api.bus.BusPacket;
import lordfokas.stargatetech2.api.bus.BusPacketLIP;
import lordfokas.stargatetech2.api.bus.IBusDevice;
import lordfokas.stargatetech2.api.bus.IBusDriver;
import lordfokas.stargatetech2.api.bus.IBusInterface;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySimpleDHD
extends TileEntity
implements IBusDevice,
IBusDriver {
    String address = "";
    IBusInterface businterface = StargateTechAPI.api().getFactory().getIBusInterface((IBusDevice)this, (IBusDriver)this);
    int face;
    private LinkedList<BusPacket> queue = new LinkedList();

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("address", this.address);
        this.businterface.writeToNBT(nbt, "interface");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("address")) {
            this.address = nbt.func_74779_i("address");
        }
        this.businterface.readFromNBT(nbt, "interface");
    }

    public void dial() {
        BusPacketLIP packet = new BusPacketLIP(0, 255);
        packet.set("action", "dial");
        packet.set("address", this.getAddress());
        packet.setMetadata(new BusPacketLIP.LIPMetadata("zettaindustries", this.getShortName(), null));
        packet.finish();
        this.handlePacket((BusPacket)packet);
        this.businterface.sendAllPackets();
    }

    public void disconnect() {
        BusPacketLIP packet = new BusPacketLIP(0, 255);
        packet.set("action", "disconnect");
        packet.setMetadata(new BusPacketLIP.LIPMetadata("zettaindustries", this.getShortName(), null));
        packet.finish();
        this.handlePacket((BusPacket)packet);
        this.businterface.sendAllPackets();
    }

    public IBusInterface[] getInterfaces(int side) {
        if (ForgeDirection.DOWN.ordinal() == side) {
            return new IBusInterface[]{this.businterface};
        }
        return new IBusInterface[0];
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public int getYCoord() {
        return this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public boolean canHandlePacket(short arg0, int arg1, boolean arg2) {
        return false;
    }

    public String getDescription() {
        return "SimpleDHD";
    }

    public short getInterfaceAddress() {
        return 0;
    }

    public BusPacket getNextPacketToSend() {
        return this.queue.isEmpty() ? null : this.queue.removeFirst();
    }

    public String getShortName() {
        return "SDHD";
    }

    public void handlePacket(BusPacket packet) {
        this.queue.addLast(packet);
    }

    public boolean isInterfaceEnabled() {
        return true;
    }
}

