/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.rfpowermeter;

import com.bymarcin.zettaindustries.mods.rfpowermeter.RFMeterTileEntity;
import com.bymarcin.zettaindustries.utils.render.RenderUtils;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class RFMeterTileEntityOC
extends RFMeterTileEntity
implements SimpleComponent,
IPeripheralProvider {
    public String getComponentName() {
        return "rfmeter";
    }

    public boolean checkPassword(int pos, Arguments args) {
        return args.isString(pos) ? this.canEdit(args.checkString(pos)) : this.canEdit(null);
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(password:string [, oldPassword:string]):bool")
    public Object[] setPassword(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        String password = args.checkString(0);
        this.setPassword(password);
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(password:string):bool")
    public Object[] removePassword(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.removePassword();
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(name:string [, password:string]):bool")
    public Object[] setName(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.name = args.checkString(0) != null ? args.checkString(0) : "";
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string")
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.name};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():number")
    public Object[] getAvg(Context ctx, Arguments arg) {
        return new Object[]{this.transfer};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] setOn(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.isOn = true;
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] setOff(Context context, Arguments args) {
        if (!this.checkPassword(0, args)) {
            return new Object[]{false};
        }
        this.isOn = false;
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(value:int [, password:string]):bool")
    public Object[] setEnergyCounter(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.value = this.lastValue = (long)args.checkInteger(0);
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():string")
    public Object[] getCounterMode(Context context, Arguments args) {
        String type = this.inCounterMode ? "counter" : "prepaid";
        return new Object[]{type};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(type:bool [, password:string]):bool -- true == counter, false == prepaid")
    public Object[] setCounterMode(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.inCounterMode = args.checkBoolean(0);
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():double")
    public Object[] getCounterValue(Context context, Arguments args) {
        return new Object[]{this.value};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function():bool")
    public Object[] canEnergyFlow(Context context, Arguments args) {
        return new Object[]{this.canEnergyFlow()};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function(limit:int [, password:string]):bool")
    public Object[] setLimitPerTick(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.transferLimit = args.checkInteger(0) >= 0 ? args.checkInteger(0) : -1;
        return new Object[]{true};
    }

    @Optional.Method(modid="OpenComputers")
    @Callback(doc="function([password:string]):bool")
    public Object[] changeFlowDirection(Context context, Arguments args) {
        if (!this.checkPassword(1, args)) {
            return new Object[]{false};
        }
        this.invert();
        return new Object[]{true};
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof RFMeterTileEntityOC) {
            return RenderUtils.FORGE_DIRECTIONS[world.func_72805_g(x, y, z)].ordinal() == side ? new RFMeterCCPeripheral((RFMeterTileEntityOC)te) : null;
        }
        return null;
    }

    @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
    public static class RFMeterCCPeripheral
    implements IPeripheral {
        RFMeterTileEntityOC te;

        public RFMeterCCPeripheral(RFMeterTileEntityOC te) {
            this.te = te;
        }

        @Optional.Method(modid="ComputerCraft")
        public String getType() {
            return "rfmeter";
        }

        @Optional.Method(modid="ComputerCraft")
        public String[] getMethodNames() {
            return new String[]{"getAVG", "canEnergyFlow", "changeFlowDirection", "getCounterMode", "getCounterValue", "getName", "removePassword", "setCounterMode", "setEnergyCounter", "setLimitPerTick", "setName", "setOff", "setOn", "setPassword"};
        }

        @Optional.Method(modid="ComputerCraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return new Object[]{this.te.transfer};
                }
                case 1: {
                    return new Object[]{this.te.canEnergyFlow()};
                }
                case 2: {
                    if (!this.checkPassword(1, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.invert();
                    return new Object[]{true};
                }
                case 3: {
                    String type = this.te.inCounterMode ? "counter" : "prepaid";
                    return new Object[]{type};
                }
                case 4: {
                    return new Object[]{this.te.value};
                }
                case 5: {
                    return new Object[]{this.te.name};
                }
                case 6: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.removePassword();
                    return new Object[]{true};
                }
                case 7: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Boolean)) {
                        return new Object[]{false};
                    }
                    this.te.inCounterMode = (Boolean)arguments[0];
                    return new Object[]{true};
                }
                case 8: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                        return new Object[]{false};
                    }
                    this.te.value = this.te.lastValue = (long)((Double)arguments[0]).intValue();
                    return new Object[]{true};
                }
                case 9: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof Double)) {
                        return new Object[]{false};
                    }
                    this.te.transferLimit = ((Double)arguments[0]).intValue() >= 0 ? ((Double)arguments[0]).intValue() : -1;
                    return new Object[]{true};
                }
                case 10: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof String)) {
                        return new Object[]{false};
                    }
                    this.te.name = (String)arguments[0];
                    return new Object[]{true};
                }
                case 11: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.isOn = false;
                    return new Object[]{true};
                }
                case 12: {
                    if (!this.checkPassword(0, arguments)) {
                        return new Object[]{false};
                    }
                    this.te.isOn = true;
                    return new Object[]{true};
                }
                case 13: {
                    if (!this.checkPassword(1, arguments) || arguments.length <= 0 || !(arguments[0] instanceof String)) {
                        return new Object[]{false};
                    }
                    String password = (String)arguments[0];
                    this.te.setPassword(password);
                    return new Object[]{true};
                }
            }
            return null;
        }

        @Optional.Method(modid="ComputerCraft")
        public boolean checkPassword(int pos, Object[] args) {
            if (args != null && pos < args.length) {
                if (args[pos] instanceof String) {
                    return this.te.canEdit((String)args[pos]);
                }
            } else if (this.te.canEdit(null)) {
                return true;
            }
            return false;
        }

        @Optional.Method(modid="ComputerCraft")
        public void attach(IComputerAccess computer) {
        }

        @Optional.Method(modid="ComputerCraft")
        public void detach(IComputerAccess computer) {
        }

        @Optional.Method(modid="ComputerCraft")
        public boolean equals(IPeripheral other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof TileEntity) {
                TileEntity tother = (TileEntity)other;
                return tother.func_145831_w().equals(this.te.field_145850_b) && tother.field_145851_c == this.te.field_145851_c && tother.field_145848_d == this.te.field_145848_d && tother.field_145849_e == this.te.field_145849_e;
            }
            return false;
        }
    }
}

