/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.quarryfixer;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.builders.TileQuarry;
import buildcraft.core.Box;
import com.bymarcin.zettaindustries.basic.BasicBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class QuarryFixerBlock
extends BasicBlock {
    private static IIcon[] topIconOn = new IIcon[4];
    private static IIcon[] topIconOff = new IIcon[4];
    private static IIcon bottomIcon;
    private static IIcon sideIcon;
    private static IIcon frontIcon;

    protected QuarryFixerBlock() {
        super(Material.field_151573_f, "quarryfixer");
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < 4; ++i) {
            QuarryFixerBlock.topIconOff[i] = iconRegister.func_94245_a("zettaindustries:quarry_fixer/quarry_fixer_top_off_" + i);
            QuarryFixerBlock.topIconOn[i] = iconRegister.func_94245_a("zettaindustries:quarry_fixer/quarry_fixer_top_on_" + i);
        }
        bottomIcon = iconRegister.func_94245_a("zettaindustries:quarry_fixer/quarry_fixer_bottom");
        sideIcon = iconRegister.func_94245_a("zettaindustries:quarry_fixer/quarry_fixer_side");
        frontIcon = iconRegister.func_94245_a("zettaindustries:quarry_fixer/quarry_fixer_front");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        switch (par1) {
            case 0: {
                return bottomIcon;
            }
            case 1: {
                switch (par2 & 3) {
                    case 0: {
                        return (par2 >> 3 & 1) == 0 ? topIconOff[par2 & 3] : topIconOn[par2 & 3];
                    }
                    case 1: {
                        return (par2 >> 3 & 1) == 0 ? topIconOff[par2 & 3] : topIconOn[par2 & 3];
                    }
                    case 2: {
                        return (par2 >> 3 & 1) == 0 ? topIconOff[par2 & 3] : topIconOn[par2 & 3];
                    }
                    case 3: {
                        return (par2 >> 3 & 1) == 0 ? topIconOff[par2 & 3] : topIconOn[par2 & 3];
                    }
                }
            }
            case 2: {
                return (par2 & 3) == 2 ? frontIcon : sideIcon;
            }
            case 3: {
                return (par2 & 3) == 0 ? frontIcon : sideIcon;
            }
            case 4: {
                return (par2 & 3) == 1 ? frontIcon : sideIcon;
            }
            case 5: {
                return (par2 & 3) == 3 ? frontIcon : sideIcon;
            }
        }
        return null;
    }

    public void func_149689_a(World par1World, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int whichDirectionFacing = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        par1World.func_72921_c(x, y, z, whichDirectionFacing, 2);
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) & 3, 2);
        super.func_149674_a(par1World, par2, par3, par4, par5Random);
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if ((par1World.func_72805_g(par2, par3, par4) & 8) != 0) {
            return true;
        }
        TileQuarry tq = null;
        int sx = par2;
        int sy = par3;
        int sz = par4;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!(par1World.func_147438_o(sx + dir.offsetX, sy + dir.offsetY, sz + dir.offsetZ) instanceof TileQuarry)) continue;
            tq = (TileQuarry)par1World.func_147438_o(sx + dir.offsetX, sy + dir.offsetY, sz + dir.offsetZ);
            break;
        }
        if (tq == null) {
            return false;
        }
        par1World.func_72921_c(par2, par3, par4, par1World.func_72805_g(par2, par3, par4) | 8, 2);
        par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World));
        Box box = tq.getBox();
        for (int x = box.xMin; x <= box.xMax; ++x) {
            for (int y = box.yMin - 1; y >= 1; --y) {
                for (int z = box.zMin; z <= box.zMax; ++z) {
                    if (x == box.xMin || x == box.xMax || z == box.zMin || z == box.zMax) {
                        if (!BuildCraftAPI.softBlocks.contains(par1World.func_147439_a(x, y, z))) continue;
                        par1World.func_147449_b(x, y, z, Blocks.field_150348_b);
                        continue;
                    }
                    if (!BuildCraftAPI.softBlocks.contains(par1World.func_147439_a(x, y, z))) continue;
                    par1World.func_147468_f(x, y, z);
                }
            }
        }
        return true;
    }
}

