/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.item;

import java.util.List;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.common.api.IDNASource;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.ilexiconn.jurassicraft.common.handler.JurassiCraftDNAHandler;
import net.ilexiconn.jurassicraft.common.item.ItemDNA;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemGenericDNASource
extends Item
implements IDNASource {
    protected String name;

    public ItemGenericDNASource(String name, String type) {
        this.func_77655_b(name + "_" + type);
        this.name = name;
        String cat = CreatureHandler.getCategoryFromCreatureName(name);
        this.func_111206_d(JurassiCraft.getModId() + "creatures/" + cat.toLowerCase() + "/" + name.toLowerCase() + "/" + name.toLowerCase() + "_" + type);
    }

    public ItemDNA getCorrespondingDNA(String type) {
        Creature creature = CreatureHandler.getCreatureFromName(this.func_77658_a().substring(5, this.func_77658_a().length() - (1 + type.length())));
        if (creature != null) {
            return creature.getDNA();
        }
        return null;
    }

    public String getDNASequence(ItemStack drop) {
        if (drop.func_77942_o() && drop.func_77978_p().func_74764_b("DNA")) {
            return drop.func_77978_p().func_74779_i("DNA");
        }
        return StatCollector.func_74838_a((String)"item.dna.info.errorCode");
    }

    public int getQuality(ItemStack drop) {
        if (drop.func_77942_o() && drop.func_77978_p().func_74764_b("Quality")) {
            return drop.func_77978_p().func_74762_e("Quality");
        }
        return 0;
    }

    public void func_77624_a(ItemStack drop, EntityPlayer player, List list, boolean flag) {
        if (drop.func_77942_o()) {
            if (drop.func_77978_p().func_74764_b("DNA")) {
                list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"item.dna.info.dna") + ": " + drop.func_77978_p().func_74779_i("DNA"));
            } else {
                list.add(StatCollector.func_74838_a((String)"item.dna.info.none"));
            }
            if (drop.func_77978_p().func_74764_b("Quality")) {
                list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"item.dna.info.quality") + ": " + drop.func_77978_p().func_74762_e("Quality") + "%");
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"item.dna.info.none"));
        }
    }

    public ItemStack func_77659_a(ItemStack drop, World world, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
            NBTTagCompound compound = drop.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            int quality = 0;
            if (compound.func_74764_b("Quality")) {
                quality = compound.func_74762_e("Quality");
            }
            if ((quality += 25) > 100) {
                quality = 0;
            }
            compound.func_74768_a("Quality", quality);
            compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            drop.func_77982_d(compound);
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.dna.info.qualityChanged") + " " + compound.func_74762_e("Quality") + "%"));
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.dna.info.geneticCodeIs") + ": " + compound.func_74779_i("DNA")));
            }
        }
        return drop;
    }
}

