/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai.herds;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.util.Vec3;

public class CreatureHerd
implements Collection<EntityJurassiCraftCreature> {
    private static List<CreatureHerd> herds = Lists.newArrayList();
    private ArrayList<EntityJurassiCraftCreature> creatures = Lists.newArrayList();
    private Class<? extends EntityJurassiCraftCreature> herdType;
    private boolean groupAttack;

    public CreatureHerd(boolean attack) {
        this.groupAttack = attack;
    }

    public static List<CreatureHerd> getHerds() {
        return herds;
    }

    public static void registerHerd(CreatureHerd herd) {
        herds.add(herd);
    }

    public static void removeHerd(CreatureHerd herd) {
        herds.remove(herd);
    }

    @Override
    public boolean add(EntityJurassiCraftCreature e) {
        if (this.isAcceptable(e)) {
            this.creatures.add(e);
            return true;
        }
        return false;
    }

    public boolean isAcceptable(EntityJurassiCraftCreature e) {
        if (this.herdType == null) {
            this.herdType = e.getClass();
            return true;
        }
        if (this.herdType == e.getClass()) {
            return this.creatures.size() < 7 && !this.contains(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends EntityJurassiCraftCreature> c) {
        boolean added = true;
        for (EntityJurassiCraftCreature entityJurassiCraftCreature : c) {
            added = added && this.add(entityJurassiCraftCreature);
        }
        return added;
    }

    @Override
    public void clear() {
        this.creatures.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.creatures.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.creatures.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.creatures.isEmpty();
    }

    @Override
    public Iterator<EntityJurassiCraftCreature> iterator() {
        return this.creatures.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.creatures.size() - 1 == 0) {
            herds.remove(this);
        }
        return this.creatures.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.creatures.size() - c.size() <= 0) {
            herds.remove(this);
        }
        return this.creatures.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.creatures.retainAll(c);
    }

    @Override
    public int size() {
        return this.creatures.size();
    }

    @Override
    public Object[] toArray() {
        return this.creatures.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.creatures.toArray(a);
    }

    public Vec3 computeCenter() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (EntityJurassiCraftCreature creature : this.creatures) {
            x += creature.field_70165_t;
            y += creature.field_70163_u;
            z += creature.field_70161_v;
        }
        return Vec3.func_72443_a((double)(x /= (double)this.creatures.size()), (double)(y /= (double)this.creatures.size()), (double)(z /= (double)this.creatures.size()));
    }

    public Vec3 getPosition(EntityJurassiCraftCreature creature, float f) {
        if (f == 1.0f) {
            return Vec3.func_72443_a((double)creature.field_70165_t, (double)creature.field_70163_u, (double)creature.field_70161_v);
        }
        double x = creature.field_70169_q + (creature.field_70165_t - creature.field_70169_q) * (double)f;
        double y = creature.field_70167_r + (creature.field_70163_u - creature.field_70167_r) * (double)f;
        double z = creature.field_70166_s + (creature.field_70161_v - creature.field_70166_s) * (double)f;
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public double getDistanceFrom(EntityJurassiCraftCreature creature) {
        Vec3 center = this.computeCenter();
        return this.getPosition(creature, 1.0f).func_72438_d(center);
    }

    public boolean groupAttack() {
        return this.groupAttack;
    }

    public CreatureHerd groupAttack(boolean attack) {
        this.groupAttack = attack;
        return this;
    }

    public void attack(EntityLivingBase target) {
        if (!this.groupAttack) {
            return;
        }
        for (EntityJurassiCraftCreature creature : this.creatures) {
            IEntityOwnable ownable;
            if (!(creature instanceof IEntityOwnable) || (ownable = (IEntityOwnable)creature).func_70902_q() != target) continue;
            return;
        }
        for (EntityJurassiCraftCreature creature : this.creatures) {
            creature.func_70624_b(target);
        }
    }

    public int indexOf(EntityJurassiCraftCreature creature) {
        return this.creatures.indexOf(creature);
    }
}

