/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.data.enums;

import net.minecraft.util.EnumChatFormatting;

public enum JurassiCraftFossilInformation {
    EXAMPLE("Species", 0, "family", 199, 191, "Diet", 1.0, 0.5, 0.5, 1, 1, "Dinosaur");

    private final String typeOfCreature;
    private final String fossilName;
    private final String family;
    private final String diet;
    private final byte fossilID;
    private final byte boundX;
    private final byte boundZ;
    private final short beginOfExistence;
    private final short endOfExistence;
    private final double weight;
    private final double length;
    private final double height;

    private JurassiCraftFossilInformation(String name, byte id, String dinoFamily, short maxYear, short minYear, String dinoDiet, double dinoWeight, double dinoLength, double dinoHeight, byte xB, byte zB, String creature) {
        this.fossilName = name;
        this.fossilID = id;
        this.family = dinoFamily;
        this.diet = dinoDiet;
        this.beginOfExistence = maxYear;
        this.endOfExistence = minYear;
        this.weight = dinoWeight;
        this.height = dinoHeight;
        this.length = dinoLength;
        this.boundX = xB;
        this.boundZ = zB;
        this.typeOfCreature = creature;
    }

    public static String getEra(double numberOfMYA) {
        if (numberOfMYA <= 252.7 && numberOfMYA > 251.2) {
            return "Induan period of the Early Triassic";
        }
        if (numberOfMYA <= 251.2 && numberOfMYA > 247.2) {
            return "Olenekian period of the Early Triassic";
        }
        if (numberOfMYA <= 247.2 && numberOfMYA > 242.0) {
            return "Anisian period of the Middle Triassic";
        }
        if (numberOfMYA <= 242.0 && numberOfMYA > 235.0) {
            return "Ladinian period of the Middle Triassic";
        }
        if (numberOfMYA <= 235.0 && numberOfMYA > 228.0) {
            return "Carnian period of the Middle Triassic";
        }
        if (numberOfMYA <= 228.0 && numberOfMYA > 208.5) {
            return "Norian period of the Late Triassic";
        }
        if (numberOfMYA <= 208.5 && numberOfMYA > 201.3) {
            return "Rhaetian period of the Late Triassic";
        }
        if (numberOfMYA <= 201.3 && numberOfMYA > 199.3) {
            return "Hettangian period of the Early Jurassic";
        }
        if (numberOfMYA <= 199.3 && numberOfMYA > 190.8) {
            return "Sinemurian period of the Early Jurassic";
        }
        if (numberOfMYA <= 190.8 && numberOfMYA > 182.7) {
            return "Pliensbachian period of the Early Jurassic";
        }
        if (numberOfMYA <= 182.7 && numberOfMYA > 174.1) {
            return "Toarcian period of the Early Jurassic";
        }
        if (numberOfMYA <= 174.1 && numberOfMYA > 170.3) {
            return "Aalenian period of the Middle Jurassic";
        }
        if (numberOfMYA <= 170.3 && numberOfMYA > 168.3) {
            return "Bajocian period of the Middle Jurassic";
        }
        if (numberOfMYA <= 168.3 && numberOfMYA > 166.1) {
            return "Bathonian period of the Middle Jurassic";
        }
        if (numberOfMYA <= 166.1 && numberOfMYA > 163.5) {
            return "Callovian period of the Middle Jurassic";
        }
        if (numberOfMYA <= 163.5 && numberOfMYA > 157.3) {
            return "Oxfordian period of the Late Jurassic";
        }
        if (numberOfMYA <= 157.3 && numberOfMYA > 152.1) {
            return "Kimmeridgian period of the Late Jurassic";
        }
        if (numberOfMYA <= 152.1 && numberOfMYA > 145.0) {
            return "Tithonian period of the Late Jurassic";
        }
        if (numberOfMYA <= 145.0 && numberOfMYA > 139.8) {
            return "Berriasian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 139.8 && numberOfMYA > 132.9) {
            return "Valanginian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 132.9 && numberOfMYA > 129.4) {
            return "Hauterivian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 129.4 && numberOfMYA > 125.0) {
            return "Barremian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 125.0 && numberOfMYA > 113.0) {
            return "Aptian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 113.0 && numberOfMYA > 100.5) {
            return "Albian period of the Early Cretaceous";
        }
        if (numberOfMYA <= 100.5 && numberOfMYA > 93.9) {
            return "Cenomanian period of the Late Cretaceous";
        }
        if (numberOfMYA <= 93.9 && numberOfMYA > 89.8) {
            return "Turonian period of the Late Cretaceous";
        }
        if (numberOfMYA <= 89.8 && numberOfMYA > 86.3) {
            return "Coniacian period of the Late Cretaceous";
        }
        if (numberOfMYA <= 86.3 && numberOfMYA > 83.3) {
            return "Santonian period of the Late Cretaceous";
        }
        if (numberOfMYA <= 83.3 && numberOfMYA > 72.1) {
            return "Campanian period of the Late Cretaceous";
        }
        if (numberOfMYA <= 72.1 && numberOfMYA >= 65.0) {
            return "Maastrichtian period of the Late Cretaceous";
        }
        return "Not Defined";
    }

    public static EnumChatFormatting getDietColor(String diet) {
        if (diet == "Carnivorous") {
            return EnumChatFormatting.RED;
        }
        if (diet == "Herbivorous") {
            return EnumChatFormatting.GREEN;
        }
        if (diet == "Piscivorous") {
            return EnumChatFormatting.BLUE;
        }
        return EnumChatFormatting.GRAY;
    }

    public String getName() {
        return this.fossilName;
    }

    public int getID() {
        return this.fossilID;
    }

    public String getDiet() {
        return this.diet;
    }

    public String getFamily() {
        return this.family;
    }

    public int getBeginOfExistence() {
        return this.beginOfExistence;
    }

    public int getEndOfExistence() {
        return this.endOfExistence;
    }

    public double getLength() {
        return this.length;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getXBound() {
        return this.boundX;
    }

    public int getZBound() {
        return this.boundZ;
    }

    public String getTypeOfCreature() {
        return this.typeOfCreature;
    }
}

