/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.tile;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.framework.json.IJsonGenMod;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.tile.ITileProvider;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileProviderByClass
extends JsonGenData
implements ITileProvider {
    public final String id;
    public final Class<? extends TileEntity> clazz;

    public TileProviderByClass(IJsonProcessor processor, String id, String clazz) throws ClassNotFoundException {
        super(processor);
        this.id = id;
        this.clazz = Class.forName(clazz);
    }

    @Override
    public TileEntity createNewTileEntity(BlockBase block, World world, int meta) {
        return this.create(this.clazz);
    }

    protected final TileEntity create(Class<? extends TileEntity> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            Engine.logger().error("Failed to create tile for TileEntity<" + this.id + ", " + clazz + ">", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Engine.logger().error("Failed to access constructor for TileEntity<" + this.id + ", " + clazz + ">", (Throwable)e);
        }
        return null;
    }

    @Override
    public void register(BlockBase block, IJsonGenMod mod, ModManager manager) {
        manager.registerTileEntity(this.id, (Block)block, this.create(this.clazz));
    }

    @Override
    public String getContentID() {
        return this.id;
    }
}

