/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive.blast;

import com.builtbroken.mc.api.edit.BlockEditResult;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.blast.BlastEventBlockReplaced;
import com.builtbroken.mc.api.event.blast.BlastEventDestroyBlock;
import com.builtbroken.mc.api.explosive.IBlastEdit;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.explosive.IExplosiveDamageable;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.data.Direction;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.imp.transform.sorting.Vector3DistanceComparator;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.prefab.entity.selector.EntityDistanceSelector;
import com.builtbroken.mc.prefab.explosive.debug.BlastProfiler;
import com.builtbroken.mc.prefab.explosive.debug.BlastRunProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;

public class BlastBasic<B extends BlastBasic>
extends Blast<B> {
    static DamageSource source = new DamageSource("blast").func_94540_d();
    static BlastProfiler profiler = new BlastProfiler();
    public float energy = 0.0f;
    protected double radius = 0.0;
    protected List<IWorldEdit> postCallDestroyMethod = new ArrayList<IWorldEdit>();
    protected BlastRunProfile profile = profiler.run(this);
    public Location center;

    public BlastBasic(IExplosiveHandler handler) {
        super(handler);
    }

    @Override
    public void getEffectedBlocks(List<IWorldEdit> list) {
        Location c = new Location(this.oldWorld(), (int)this.x(), (int)this.y(), (int)this.z());
        this.center = (Location)c.add(0.5);
        HashMap<IBlastEdit, Float> map = new HashMap<IBlastEdit, Float>();
        this.profile.startSection("getEffectedBlocks");
        this.profile.startSection("Pathfinder");
        BlockEdit edit = new BlockEdit(this);
        this.triggerPathFinder(map, edit, this.energy);
        this.profile.endSection("Pathfinder");
        list.addAll(map.keySet());
        this.profile.startSection("Sorter");
        Collections.sort(list, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
        this.profile.endSection("Sorter");
        this.profile.endSection("getEffectedBlocks");
        if (Engine.runningAsDev) {
            Engine.logger().info((Object)this.profile.getOutputSimple());
        }
    }

    protected void triggerPathFinder(HashMap<IBlastEdit, Float> map, IBlastEdit vec, float energy) {
        this.expand(map, vec, energy, null, 0);
    }

    protected void expand(HashMap<IBlastEdit, Float> map, IBlastEdit vec, float energy, Direction side, int iteration) {
        ++this.profile.tilesPathed;
        long timeStart = System.nanoTime();
        if ((double)iteration < this.size * 2.0) {
            float energyCost = Math.abs(this.getEnergyCostOfTile(vec, energy));
            float energyLeft = energy - energyCost;
            if (energyCost >= 0.0f && energyLeft > 1.0f) {
                vec.setEnergy(energy);
                IBlastEdit blastEdit = this.onBlockMapped(vec, energyCost, energyLeft);
                if (blastEdit != null) {
                    map.put(blastEdit, Float.valueOf(energyCost));
                    if (energyLeft > 1.0f) {
                        ArrayList<BlockEdit> sides = new ArrayList<BlockEdit>();
                        for (Direction dir : Direction.DIRECTIONS) {
                            if (dir == side) continue;
                            BlockEdit v = new BlockEdit(this.oldWorld, vec, dir);
                            v.doDrops();
                            v.setBlastDirection(dir);
                            v.logPrevBlock();
                            sides.add(v);
                        }
                        Collections.sort(sides, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
                        this.profile.blockIterationTimes.add(System.nanoTime() - timeStart);
                        for (IBlastEdit iBlastEdit : sides) {
                            Direction face;
                            float eToSpend = energyLeft / (float)sides.size() + energyLeft % (float)sides.size();
                            energyLeft -= eToSpend;
                            Direction direction = face = side == null ? this.getOpposite(iBlastEdit.getBlastDirection()) : side;
                            if (map.containsKey(iBlastEdit) && !(map.get(iBlastEdit).floatValue() < eToSpend)) continue;
                            iBlastEdit.setBlastDirection(face);
                            this.expand(map, iBlastEdit, eToSpend, face, iteration + 1);
                        }
                    }
                }
            }
        }
    }

    private Direction getOpposite(Direction face) {
        if (face != null) {
            switch (face) {
                case UP: {
                    return Direction.DOWN;
                }
                case DOWN: {
                    return Direction.UP;
                }
                case NORTH: {
                    return Direction.SOUTH;
                }
                case SOUTH: {
                    return Direction.NORTH;
                }
                case EAST: {
                    return Direction.WEST;
                }
                case WEST: {
                    return Direction.EAST;
                }
            }
            return null;
        }
        return null;
    }

    protected float getEnergyCostOfTile(IBlastEdit vec, float energy) {
        Block block = vec.getBlock();
        TileEntity tileEntity = vec.getTileEntity();
        IExplosiveDamageable damageableTile = null;
        if (tileEntity instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)tileEntity;
        } else if (tileEntity instanceof ITileNodeHost && ((ITileNodeHost)tileEntity).getTileNode() instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)((Object)((ITileNodeHost)tileEntity).getTileNode());
        }
        if (damageableTile != null) {
            return damageableTile.getEnergyCostOfTile(this.explosiveHandler, this, vec.getBlastDirection(), energy, (float)this.center.distance((double)vec.xi() + 0.5, (double)vec.yi() + 0.5, (double)vec.zi() + 0.5));
        }
        if (block.isAir((IBlockAccess)this.oldWorld, vec.xi(), vec.yi(), vec.zi())) {
            ++this.profile.airBlocksPathed;
        } else {
            ++this.profile.blocksRemoved;
        }
        return block.func_149712_f(this.oldWorld, vec.xi(), vec.yi(), vec.zi()) >= 0.0f ? (float)Math.max((double)block.getExplosionResistance(this.explosionBlameEntity, this.oldWorld, vec.xi(), vec.yi(), vec.zi(), this.x, this.y, this.z), 0.5) : -1.0f;
    }

    @Override
    public void handleBlockPlacement(IWorldEdit vec) {
        if (vec != null && vec.hasChanged() && this.prePlace(vec)) {
            Block block = vec.getBlock();
            if (!(block instanceof BlockTNT) && !(vec.getTileEntity() instanceof IExplosive)) {
                block.func_149723_a(this.oldWorld, (int)vec.x(), (int)vec.y(), (int)vec.z(), this.wrapperExplosion);
            } else {
                this.postCallDestroyMethod.add(vec);
            }
            BlockEditResult result = vec.place();
            if (Engine.runningAsDev) {
                System.out.println("Result: " + (Object)((Object)result) + "   Edit: " + vec + "  Block: " + vec.getBlock() + "  Tile: " + vec.getTileEntity());
            }
            this.postPlace(vec);
        }
    }

    protected IBlastEdit onBlockMapped(IBlastEdit change, float energyExpended, float energyLeft) {
        TileEntity tileEntity = change.getTileEntity();
        IExplosiveDamageable damageableTile = null;
        if (tileEntity instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)tileEntity;
        } else if (tileEntity instanceof ITileNodeHost && ((ITileNodeHost)tileEntity).getTileNode() instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)((Object)((ITileNodeHost)tileEntity).getTileNode());
        }
        if (damageableTile != null) {
            return damageableTile.getBlockEditOnBlastImpact(this.explosiveHandler, this, change.getBlastDirection(), this.energy, (float)this.center.distance((double)change.xi() + 0.5, (double)change.yi() + 0.5, (double)change.zi() + 0.5));
        }
        if (energyExpended > energyLeft) {
            change.doDrops();
        }
        return change;
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
        AxisAlignedBB bounds;
        List list;
        if (!beforeBlocksPlaced && (list = this.oldWorld.func_82733_a(Entity.class, bounds = AxisAlignedBB.func_72330_a((double)(this.x - this.size - 1.0), (double)(this.y - this.size - 1.0), (double)(this.z - this.size - 1.0), (double)(this.x + this.size + 1.0), (double)(this.y + this.size + 1.0), (double)(this.z + this.size + 1.0)), (IEntitySelector)new EntityDistanceSelector(new Pos(this.x, this.y, this.z), this.size + 1.0, true))) != null && !list.isEmpty()) {
            this.damageEntities(list, source);
        }
    }

    @Override
    public B setYield(double size) {
        super.setYield(size);
        this.radius = size;
        this.calcStartingEnergy();
        return (B)this;
    }

    protected void calcStartingEnergy() {
        this.energy = (float)(MathUtility.getSphereVolume(this.radius) * (double)this.eUnitPerBlock);
    }

    @Override
    protected void postPlace(IWorldEdit vec) {
        MinecraftForge.EVENT_BUS.post((Event)new BlastEventDestroyBlock.Post(this, BlastEventDestroyBlock.DestructionType.FORCE, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), (int)vec.x(), (int)vec.y(), (int)vec.z()));
    }

    @Override
    protected boolean prePlace(IWorldEdit vec) {
        BlastEventDestroyBlock.Pre event = new BlastEventDestroyBlock.Pre(this, BlastEventDestroyBlock.DestructionType.FORCE, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), (int)vec.x(), (int)vec.y(), (int)vec.z());
        boolean result = MinecraftForge.EVENT_BUS.post((Event)event);
        if (vec instanceof IBlastEdit && event instanceof BlastEventBlockReplaced.Pre && ((BlastEventBlockReplaced.Pre)((Object)event)).newBlock != null) {
            vec.set(((BlastEventBlockReplaced.Pre)((Object)event)).newBlock, ((BlastEventBlockReplaced.Pre)((Object)event)).newMeta);
        }
        return !result;
    }
}

