/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUtility {
    private static HashMap<Block, Float> BLOCK_HARDNESS = new HashMap();
    private static HashMap<Block, Float> BLOCK_RESISTANCE = new HashMap();
    public static final String[] CHUNK_RELIGHT_BLOCK = new String[]{"relightBlock", "func_76615_h"};
    public static final String[] CHUNK_PROPOGATE_SKY_LIGHT_OCCLUSION = new String[]{"propagateSkylightOcclusion", "func_76595_e"};

    public static float getBlockResistance(Block block) {
        if (BLOCK_RESISTANCE.containsKey(block)) {
            return BLOCK_RESISTANCE.get(block).floatValue();
        }
        try {
            Field field = ReflectionUtility.getMCField(Block.class, "blockResistance", "field_149781_w");
            BLOCK_RESISTANCE.put(block, Float.valueOf(field.getFloat(block)));
            return BLOCK_RESISTANCE.get(block).floatValue();
        }
        catch (Exception e) {
            Engine.logger().info("Failed to reflect into Block.class to get block resistance");
            Engine.logger().catching((Throwable)e);
            return 0.0f;
        }
    }

    public static float getBlockHardness(Block block) {
        if (BLOCK_HARDNESS.containsKey(block)) {
            return BLOCK_HARDNESS.get(block).floatValue();
        }
        try {
            Field field = ReflectionUtility.getMCField(Block.class, "blockHardness", "field_149782_v");
            BLOCK_HARDNESS.put(block, Float.valueOf(field.getFloat(block)));
            return BLOCK_HARDNESS.get(block).floatValue();
        }
        catch (Exception e) {
            Engine.logger().info("Failed to reflect into Block.class to get block hardness");
            Engine.logger().catching((Throwable)e);
            return 0.0f;
        }
    }

    public static float getBlockHardness(ItemStack stack) {
        return BlockUtility.getBlockHardness(Block.func_149634_a((Item)stack.func_77973_b()));
    }

    public static void setBlockSneaky(World world, Pos position, Block block, int metadata, TileEntity tileEntity) {
        if (block != null && world != null) {
            Chunk chunk = world.func_72964_e(position.xi() >> 4, position.zi() >> 4);
            Pos chunkPosition = new Pos(position.xi() & 0xF, position.yi() & 0xF, position.zi() & 0xF);
            int heightMapIndex = chunkPosition.zi() << 4 | chunkPosition.xi();
            if (position.yi() >= chunk.field_76638_b[heightMapIndex] - 1) {
                chunk.field_76638_b[heightMapIndex] = -999;
            }
            int heightMapValue = chunk.field_76634_f[heightMapIndex];
            world.func_147475_p(position.xi(), position.yi(), position.zi());
            ExtendedBlockStorage extendedBlockStorage = chunk.func_76587_i()[position.yi() >> 4];
            if (extendedBlockStorage == null) {
                chunk.func_76587_i()[position.yi() >> 4] = extendedBlockStorage = new ExtendedBlockStorage(position.yi() >> 4 << 4, !world.field_73011_w.field_76576_e);
            }
            extendedBlockStorage.func_150818_a(chunkPosition.xi(), chunkPosition.yi(), chunkPosition.zi(), block);
            extendedBlockStorage.func_76654_b(chunkPosition.xi(), chunkPosition.yi(), chunkPosition.zi(), metadata);
            if (position.yi() >= heightMapValue) {
                chunk.func_76603_b();
            } else {
                if (chunk.func_76629_c(chunkPosition.xi(), position.yi(), chunkPosition.zi(), 0) > 0) {
                    if (position.yi() >= heightMapValue) {
                        BlockUtility.relightBlock(chunk, (Pos)((Pos)chunkPosition.clone()).add(new Pos(0.0, 1.0, 0.0)));
                    }
                } else if (position.yi() == heightMapValue - 1) {
                    BlockUtility.relightBlock(chunk, chunkPosition);
                }
                BlockUtility.propagateSkylightOcclusion(chunk, chunkPosition);
            }
            chunk.field_76643_l = true;
            world.func_147451_t(position.xi(), position.yi(), position.zi());
            if (tileEntity != null) {
                world.func_147455_a(position.xi(), position.yi(), position.zi(), tileEntity);
            }
            world.func_147471_g(position.xi(), position.yi(), position.zi());
        }
    }

    public static void relightBlock(Chunk chunk, Pos position) {
        try {
            Method m = ReflectionHelper.findMethod(Chunk.class, null, (String[])CHUNK_RELIGHT_BLOCK, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
            m.invoke((Object)chunk, position.xi(), position.yi(), position.zi());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void propagateSkylightOcclusion(Chunk chunk, Pos position) {
        try {
            Method m = ReflectionHelper.findMethod(Chunk.class, null, (String[])CHUNK_PROPOGATE_SKY_LIGHT_OCCLUSION, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            m.invoke((Object)chunk, position.xi(), position.zi());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static byte determineOrientation(int x, int y, int z, Entity entityLiving) {
        if (entityLiving != null) {
            int rotation;
            if ((float)MathUtility.func_154353_e(entityLiving.field_70165_t - (double)x) < 2.0f && (float)MathUtility.func_154353_e(entityLiving.field_70161_v - (double)z) < 2.0f) {
                double var5 = entityLiving.field_70163_u + 1.82 - entityLiving.func_70033_W();
                if (var5 - (double)y > 2.0) {
                    return 1;
                }
                if ((double)y - var5 > 0.0) {
                    return 0;
                }
            }
            if ((rotation = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0) {
                return 2;
            }
            if (rotation == 1) {
                return 5;
            }
            if (rotation == 2) {
                return 3;
            }
            if (rotation == 3) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public static byte determineOrientation(int x, int y, int z, IEntityData entityLiving) {
        if (entityLiving != null) {
            int rotation;
            if ((float)MathUtility.func_154353_e(entityLiving.x() - (double)x) < 2.0f && (float)MathUtility.func_154353_e(entityLiving.z() - (double)z) < 2.0f) {
                double var5 = entityLiving.y() + 1.82 - entityLiving.getYOffset();
                if (var5 - (double)y > 2.0) {
                    return 1;
                }
                if ((double)y - var5 > 0.0) {
                    return 0;
                }
            }
            if ((rotation = MathHelper.func_76128_c((double)(entityLiving.yaw() * 4.0 / 360.0 + 0.5)) & 3) == 0) {
                return 2;
            }
            if (rotation == 1) {
                return 5;
            }
            if (rotation == 2) {
                return 3;
            }
            if (rotation == 3) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public static byte determineRotation(double rotationYaw) {
        int rotation = MathHelper.func_76128_c((double)(rotationYaw * 4.0 / 360.0 + 0.5)) & 3;
        if (rotation == 0) {
            return 3;
        }
        if (rotation == 1) {
            return 4;
        }
        if (rotation == 2) {
            return 2;
        }
        if (rotation == 3) {
            return 5;
        }
        return 0;
    }

    public static ForgeDirection determineForgeDirection(IEntityData entityLiving) {
        return ForgeDirection.getOrientation((int)BlockUtility.determineRotation(entityLiving.yaw()));
    }

    public static ForgeDirection determineForgeDirection(int x, int y, int z, IEntityData entityLiving, boolean ignorePitch) {
        if (ignorePitch) {
            return ForgeDirection.getOrientation((int)BlockUtility.determineRotation(entityLiving.yaw()));
        }
        return ForgeDirection.getOrientation((int)BlockUtility.determineOrientation(x, y, z, entityLiving));
    }
}

