/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.logic;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.Pos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.tile.IPlayerUsing;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.block.imp.IPlacementListener;
import com.builtbroken.mc.framework.logic.imp.ITileDesc;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.gui.ContainerBase;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileNode
implements ITileNode,
IPacketIDReceiver,
ITileDesc,
IPlacementListener,
IPlayerUsing {
    protected static int DESCRIPTION_PACKET_ID = -1;
    protected static int GUI_PACKET_ID = -2;
    protected ITileNodeHost host;
    protected final String id;
    protected final String mod;
    protected String username;
    protected UUID owner;
    private final List<EntityPlayer> guiUsers = new ArrayList<EntityPlayer>();

    public TileNode(String id, String mod) {
        this.id = id;
        this.mod = mod;
    }

    @Override
    public void update(long ticks) {
        if (this.isServer() && ticks % 3L == 0L) {
            this.doUpdateGuiUsers();
        }
    }

    @Override
    public void setHost(ITileNodeHost host) {
        this.host = host;
    }

    @Override
    public ITileNodeHost getHost() {
        return this.host;
    }

    public List<EntityPlayer> getPlayersUsing() {
        return this.guiUsers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClassDisplayName());
        builder.append("(");
        this.toStringData(builder);
        builder.append(")@");
        builder.append(this.hashCode());
        return builder.toString();
    }

    protected String getClassDisplayName() {
        return this.getClass().getName();
    }

    protected void toStringData(StringBuilder builder) {
        builder.append("host = ");
        builder.append(this.host.getClass().getName());
        builder.append("@");
        builder.append(this.host.hashCode());
    }

    @Override
    @Deprecated
    public final Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }

    @Deprecated
    public final Location toLocation() {
        return new Location((World)this.world().unwrap(), this.x(), this.y(), this.z());
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tileOwnerMostSigBit") && nbt.func_74764_b("tileOwnerLeastSigBit")) {
            this.owner = new UUID(nbt.func_74763_f("tileOwnerMostSigBit"), nbt.func_74763_f("tileOwnerLeastSigBit"));
        }
        if (nbt.func_74764_b("tileOwnerUsername")) {
            this.username = nbt.func_74779_i("tileOwnerUsername");
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.owner != null) {
            nbt.func_74772_a("tileOwnerMostSigBit", this.owner.getMostSignificantBits());
            nbt.func_74772_a("tileOwnerLeastSigBit", this.owner.getLeastSignificantBits());
        }
        if (this.username != null && !this.username.isEmpty()) {
            nbt.func_74778_a("tileOwnerUsername", this.username);
        }
        return nbt;
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (id == DESCRIPTION_PACKET_ID) {
            if (this.isClient()) {
                this.readDescPacket(player, buf);
            }
            return true;
        }
        if (id == GUI_PACKET_ID) {
            if (this.isClient()) {
                this.readGuiPacket(player, buf);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldReadPacket(EntityPlayer player, IWorldPosition receiveLocation, PacketType packet) {
        if (this.isClient()) return true;
        Location location = new Location((Entity)player);
        if (!(location.distance(receiveLocation.x(), receiveLocation.y(), receiveLocation.z()) < 10.0)) return false;
        if (!(packet instanceof PacketTile)) return false;
        return true;
    }

    @Override
    public IPacket getDescPacket() {
        try {
            IPacket packet = this.getPacketForData(new Object[0]);
            packet.data().writeInt(DESCRIPTION_PACKET_ID);
            this.writeDescPacket(packet.data());
            return packet;
        }
        catch (Exception e) {
            Engine.logger().error("Failed to write description packet for " + this + "  ", (Throwable)e);
            return null;
        }
    }

    public void readDescPacket(ByteBuf buf) {
    }

    public void writeDescPacket(ByteBuf buf) {
    }

    public void readDescPacket(EntityPlayer player, ByteBuf buf) {
        this.readDescPacket(buf);
    }

    public void writeDescPacket(EntityPlayer player, ByteBuf buf) {
        this.writeDescPacket(buf);
    }

    protected void writeGuiPacket(EntityPlayer player, ByteBuf buf) {
    }

    protected void readGuiPacket(EntityPlayer player, ByteBuf buf) {
    }

    public double distance(IPos3D pos) {
        if (pos instanceof Pos3D) {
            return ((Pos3D)pos).distance(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
        }
        return this.distance(pos.x(), pos.y(), pos.z());
    }

    public double distance(double x, double y, double z) {
        double xx = this.x() + 0.5 - x;
        double yy = this.y() + 0.5 - y;
        double zz = this.z() + 0.5 - z;
        return Math.sqrt(xx * xx + yy * yy + zz * zz);
    }

    @Override
    public void onPlacedBy(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (entityLivingBase instanceof EntityPlayer) {
            this.setOwner((EntityPlayer)entityLivingBase);
        }
    }

    public UUID getOwnerID() {
        return this.owner;
    }

    public String getOwnerName() {
        GameProfile profile = this.getOwnerProfile();
        if (profile != null) {
            return profile.getName();
        }
        return null;
    }

    public GameProfile getOwnerProfile() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        return MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(this.owner);
    }

    public boolean isOwner(EntityPlayer player) {
        if (player != null) {
            if (this.getOwnerID() != null) {
                return this.getOwnerID().equals(player.func_146103_bH().getId());
            }
            if (this.getOwnerName() != null) {
                return player.func_70005_c_().equalsIgnoreCase(this.getOwnerName());
            }
            return true;
        }
        return false;
    }

    public void setOwnerID(UUID id) {
        this.owner = id;
    }

    public void setOwner(EntityPlayer player) {
        if (player != null) {
            this.setOwnerID(player.func_146103_bH().getId());
            this.username = player.func_70005_c_();
        } else {
            this.setOwnerID(null);
            this.username = null;
        }
    }

    public void sendDescPacket() {
        if (this.world() != null && this.isServer()) {
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (EntityPlayer player : players) {
                if (!(player instanceof EntityPlayerMP) || player.field_70170_p != this.world().unwrap()) continue;
                IPacket packet = this.getPacketForData(new Object[0]);
                packet.data().writeInt(DESCRIPTION_PACKET_ID);
                this.writeDescPacket(player, packet.data());
                Engine.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player);
            }
        }
    }

    public void sendPacketToGuiUsers(IPacket packet) {
        if (this.world() != null && this.isServer() && packet != null) {
            Iterator players = this.getPlayersUsing().iterator();
            while (players.hasNext()) {
                EntityPlayer player = (EntityPlayer)players.next();
                if (this.isValidToSendGUIPacket(player)) {
                    Engine.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player);
                    continue;
                }
                players.remove();
            }
        }
    }

    public void doUpdateGuiUsers() {
        if (this.world() != null && this.isServer() && this instanceof IGuiTile) {
            Iterator players = this.getPlayersUsing().iterator();
            while (players.hasNext()) {
                EntityPlayer player = (EntityPlayer)players.next();
                if (this.isValidToSendGUIPacket(player)) {
                    IPacket packet = this.getHost().getPacketForData(GUI_PACKET_ID);
                    this.writeGuiPacket(player, packet.data());
                    Engine.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player);
                    continue;
                }
                players.remove();
            }
        }
    }

    protected boolean isValidToSendGUIPacket(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            Container container = player.field_71070_bA;
            if (container instanceof ContainerDummy) {
                return ((ContainerDummy)container).tile == this;
            }
            if (container instanceof ContainerBase) {
                return ((ContainerBase)container).host == this;
            }
        }
        return false;
    }

    public boolean isInvalid() {
        if (this.getHost() instanceof TileEntity) {
            return ((TileEntity)this.getHost()).func_145837_r();
        }
        if (this.getHost() instanceof Entity) {
            return !((Entity)this.getHost()).func_70089_S();
        }
        return true;
    }

    @Override
    public final String getListenerKey() {
        return "";
    }

    @Override
    public String getUniqueID() {
        return this.id;
    }

    @Override
    public String contentType() {
        return "node";
    }

    @Override
    public String getMod() {
        return this.mod;
    }
}

