/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive.handler;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.framework.explosive.handler.ExplosiveData;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ExplosiveHandler<B extends Blast>
implements IExplosiveHandler {
    protected final ExplosiveData data;

    public ExplosiveHandler(ExplosiveData data) {
        this.data = data;
    }

    @Deprecated
    public ExplosiveHandler(String name) {
        this(name, 1);
    }

    @Deprecated
    public ExplosiveHandler(String name, int multi) {
        this(new ExplosiveData(null));
        this.data.translationKey = name;
        this.data.multiplier = multi;
    }

    @Override
    public void addInfoToItem(EntityPlayer player, ItemStack stack, List<String> lines) {
        lines.add(LanguageUtility.getLocal("info.voltzengine:explosive.name") + ": " + LanguageUtility.getLocal(this.getTranslationKey() + ".name"));
        if (stack != null) {
            String s;
            String s2;
            ItemStack ex_stack;
            if (stack.func_77973_b() instanceof IExplosiveContainerItem && (ex_stack = ((IExplosiveContainerItem)stack.func_77973_b()).getExplosiveStack(stack)) != null && (s2 = LanguageUtility.getLocal("info.voltzengine:explosive.item.name")) != null && !s2.isEmpty()) {
                lines.add(s2 + ": " + ex_stack.func_82833_r());
            }
            if (ExplosiveRegistry.getExplosiveSize(stack) > 0.0 && (s = LanguageUtility.getLocal("info.voltzengine:explosive.yield.name")) != null && !s.isEmpty()) {
                String yield = "" + ExplosiveRegistry.getExplosiveSize(stack) * this.getYieldModifier(stack);
                yield = yield.substring(0, Math.min(yield.indexOf(".") + 2, yield.length()));
                lines.add(String.format(s, yield));
            }
        }
    }

    @Override
    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        B blast = this.newBlast(tag);
        if (blast != null) {
            ((Blast)blast).setLocation(world, x, y, z);
            ((Blast)blast).setCause(triggerCause);
            ((Blast)blast).setYield(size * this.getYieldModifier());
            ((Blast)blast).setAdditionBlastData(tag);
            this.addData(blast);
        }
        return blast;
    }

    protected void addData(B blast) {
    }

    protected B newBlast(NBTTagCompound tag) {
        return this.newBlast();
    }

    protected B newBlast() {
        return null;
    }

    @Override
    public double getYieldModifier(ItemStack stack) {
        return this.getYieldModifier();
    }

    @Override
    public double getYieldModifier() {
        return this.data.multiplier;
    }

    @Override
    public void onRegistered(String id, String modID) {
        this.data.id = id;
        this.data.modID = modID;
    }

    @Override
    public String getTranslationKey() {
        return "explosive." + this.data.modID + ":" + this.data.translationKey;
    }

    @Override
    public String getID() {
        return this.data.id;
    }

    @Override
    public String getMod() {
        return this.data.modID;
    }

    public String toString() {
        return "ExHandler[" + this.getID() + "]";
    }
}

