/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.api.event;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TriggerCause {
    public final String triggerName;
    public float effectScaleChange = 1.0f;

    public TriggerCause(String name) {
        this.triggerName = name;
    }

    public static class TriggerCauseRedstone
    extends TriggerCauseSide {
        public final int strength;

        public TriggerCauseRedstone(ForgeDirection side, int strength) {
            super("redstone", side);
            this.strength = strength;
        }
    }

    public static class TriggerCauseFire
    extends TriggerCauseSide {
        public TriggerCauseFire(ForgeDirection side) {
            super("fire", side);
        }
    }

    public static class TriggerCauseExplosion
    extends TriggerCause {
        public final Explosion source;

        public TriggerCauseExplosion(Explosion source) {
            super("explosion");
            this.source = source;
        }
    }

    public static class TriggerEntityImpact
    extends TriggerCauseImpact {
        public final Entity entityHit;

        public TriggerEntityImpact(Entity entityHit, Entity source, float velocity) {
            this("entityImpactEntity", entityHit, source, velocity);
        }

        public TriggerEntityImpact(String name, Entity entityHit, Entity source, float velocity) {
            super(name, source, velocity);
            this.entityHit = entityHit;
        }
    }

    public static class TriggerBlockImpact
    extends TriggerCauseImpact {
        public final Block impactBlock;

        public TriggerBlockImpact(Block block, Entity source, float velocity) {
            this("entityImpactBlock", block, source, velocity);
        }

        public TriggerBlockImpact(String name, Block block, Entity source, float velocity) {
            super(name, source, velocity);
            this.impactBlock = block;
        }
    }

    public static class TriggerCauseImpact
    extends TriggerCauseEntity {
        public final float velocity;

        public TriggerCauseImpact(Entity source, float velocity) {
            this("entityImpact", source, velocity);
        }

        public TriggerCauseImpact(String name, Entity source, float velocity) {
            super(name, source);
            this.velocity = velocity;
        }
    }

    public static class TriggerCauseEntity
    extends TriggerCause {
        public final Entity source;

        public TriggerCauseEntity(Entity source) {
            this("entity", source);
        }

        public TriggerCauseEntity(String name, Entity source) {
            super(name);
            this.source = source;
        }
    }

    public static abstract class TriggerCauseSide
    extends TriggerCause {
        public final ForgeDirection triggeredSide;

        public TriggerCauseSide(String name, ForgeDirection side) {
            super(name);
            this.triggeredSide = side;
        }
    }
}

