/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.loot;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class LootMap {
    private HashMap<String, LootItem> generalMap;
    private ArrayList<String> generalLootSources;
    private ArrayList<String> generalModBlacklist;
    private ArrayList<LootItem> generalBlacklist;
    private ArrayList<LootItem> generalWhitelist;
    public HashMap<String, LootItem> totalList;
    public ArrayList<LootItem> recyclerBlacklist;
    public ArrayList<LootItem> recyclerWhitelist;
    private int generalTotalWeight;

    public LootMap() {
        this.clearMapData();
    }

    public void clearMapData() {
        this.generalMap = new HashMap();
        this.generalLootSources = new ArrayList();
        this.generalModBlacklist = new ArrayList();
        this.generalBlacklist = new ArrayList();
        this.generalWhitelist = new ArrayList();
        this.recyclerBlacklist = new ArrayList();
        this.recyclerWhitelist = new ArrayList();
        this.totalList = new HashMap();
        this.generalTotalWeight = 0;
    }

    public void populateRecyclerBlacklist(ArrayList<String> configRecyclerBlacklist) {
        for (String s : configRecyclerBlacklist) {
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 3) {
                try {
                    String modid = tempwords[0];
                    String itemname = tempwords[1];
                    ArrayList<Integer> itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, 1, 1, 1, false);
                        this.recyclerBlacklist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Blacklist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Blacklist Error: Line: " + s + " Improperly formed Blacklisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Recycler Blacklist Error: Line: " + s + " Improperly formed Blacklisted item.");
        }
    }

    public void populateRecyclerWhitelist(ArrayList<String> configRecyclerWhitelist) {
        for (String s : configRecyclerWhitelist) {
            int weight;
            ArrayList<Integer> itemdamage;
            String itemname;
            String modid;
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 4) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    weight = Integer.parseInt(tempwords[3]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, 1, 1, weight, false);
                        this.recyclerWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Whitelist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            if (tempwords.length == 5) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    weight = Integer.parseInt(tempwords[3]);
                    byte[] nbt = LootbagsUtil.parseNBTArray(tempwords[4]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, 1, 1, weight, nbt, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Whitelist Item with NBT: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed NBT Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed Whitelisted item.");
        }
    }

    public void populateGeneralBlacklist(ArrayList<String> configBlacklist) {
        for (String s : configBlacklist) {
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 1) {
                if (this.generalModBlacklist.contains(tempwords[0])) continue;
                this.generalModBlacklist.add(tempwords[0]);
                continue;
            }
            if (tempwords.length == 3) {
                try {
                    String modid = tempwords[0];
                    String itemname = tempwords[1];
                    ArrayList<Integer> itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, 1, 1, 1, false);
                        this.generalBlacklist.add(item);
                        LootbagsUtil.LogInfo("Added General Blacklist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Blacklist Error: Line: " + s + " Improperly formed Blacklisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Blacklist Error: Line: " + s + " Improperly formed Blacklisted item.");
        }
    }

    public void populateGeneralWhitelist(ArrayList<String> configWhitelist) {
        for (String s : configWhitelist) {
            int weight;
            int maxstack;
            int minstack;
            ArrayList<Integer> itemdamage;
            String itemname;
            String modid;
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 6) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    minstack = Integer.parseInt(tempwords[3]);
                    maxstack = Integer.parseInt(tempwords[4]);
                    weight = Integer.parseInt(tempwords[5]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, minstack, maxstack, weight, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Whitelist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            if (tempwords.length == 7) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    minstack = Integer.parseInt(tempwords[3]);
                    maxstack = Integer.parseInt(tempwords[4]);
                    weight = Integer.parseInt(tempwords[5]);
                    byte[] nbt = LootbagsUtil.parseNBTArray(tempwords[6]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(modid, itemname, dam, minstack, maxstack, weight, nbt, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Whitelist Item with NBT: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed NBT Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed Whitelisted item.");
        }
    }

    public void populateGeneralMap() {
        for (String source : this.generalLootSources) {
            this.addLootCategory(source);
        }
        for (LootItem item : this.generalWhitelist) {
            if (item.getContentItem() == null) {
                item.reinitializeLootItem();
            }
            if (item.getContentItem() == null) {
                LootbagsUtil.LogError("Loot Item with information: " + item.getItemModID() + ":" + item.getItemName() + " does not exist, even after reinitilizing it. This typically means the whitelist entry is wrong. This item will be skipped.");
                continue;
            }
            String key = item.getItemModID() + item.getItemName() + item.getContentItem().field_76297_b.func_77960_j();
            if (item.getContentItem().field_76297_b.func_77973_b() instanceof ItemEnchantedBook && item.getContentItem().field_76297_b.func_77942_o()) {
                key = key + item.getContentItem().field_76297_b.func_77978_p().toString();
            }
            if (this.generalMap.containsKey(key)) {
                this.generalMap.remove(key);
            }
            this.generalMap.put(key, item);
            if (this.totalList.containsKey(key)) continue;
            this.totalList.put(key, item);
        }
    }

    public void addLootCategory(String categoryName) {
        LootbagsUtil.LogInfo("Starting adding items from loot category: " + categoryName + ".");
        WeightedRandomChestContent[] h = ChestGenHooks.getItems((String)categoryName, (Random)LootBags.getRandom());
        for (int i = 0; i < h.length; ++i) {
            LootItem item;
            WeightedRandomChestContent c = h[i];
            boolean skip = false;
            try {
                item = new LootItem(c, true);
            }
            catch (Exception e) {
                item = null;
                skip = true;
                LootbagsUtil.LogError("Creation of Loot Item failed!  This is an issue with a different mod!");
            }
            if (skip) continue;
            if (item.getContentItem().field_76292_a < 1) {
                LootbagsUtil.LogError("Item " + item.getContentItem().field_76297_b.toString() + " has a weighting of " + item.getContentItem().field_76292_a + ".  This is not a Lootbags error but an error in a different mod!  This item will be excluded from the Lootbags loot table.");
                continue;
            }
            for (String modid : this.generalModBlacklist) {
                if (!GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).modId.equalsIgnoreCase(modid)) continue;
                skip = true;
                LootbagsUtil.LogInfo("Found item to skip from Blacklisted mod: " + item.toString());
            }
            for (LootItem entry : this.generalBlacklist) {
                String name = entry.getItemName();
                if (!GameRegistry.findUniqueIdentifierFor((Item)c.field_76297_b.func_77973_b()).name.equalsIgnoreCase(name)) continue;
                skip = true;
                LootbagsUtil.LogInfo("Found Blacklisted item to skip: " + item.toString());
            }
            if (skip) continue;
            String key = item.getItemModID() + item.getItemName() + item.getContentItem().field_76297_b.func_77960_j();
            if (!this.generalMap.containsKey(key)) {
                this.generalMap.put(key, item);
                if (this.totalList.containsKey(key)) continue;
                this.totalList.put(key, item);
                continue;
            }
            LootItem it = this.generalMap.get(key);
            int weight = it.getContentItem().field_76292_a;
            it.getContentItem().field_76292_a = weight = (weight + c.field_76292_a) / 2;
            this.generalMap.put(key, it);
            if (this.totalList.containsKey(key)) continue;
            this.totalList.put(key, it);
        }
    }

    public ArrayList<LootItem> getMapByWeight(int minWeight, int maxWeight) {
        ArrayList<LootItem> ret = new ArrayList<LootItem>();
        for (LootItem item : this.generalMap.values()) {
            if (minWeight != -1 && item.getItemWeight() < minWeight || maxWeight != -1 && item.getItemWeight() > maxWeight) continue;
            ret.add(item);
        }
        Collections.sort(ret);
        return ret;
    }

    public HashMap<String, LootItem> getMap() {
        return this.generalMap;
    }

    public void setTotalListWeight() {
        this.generalTotalWeight = 0;
        for (LootItem item : this.totalList.values()) {
            this.generalTotalWeight += item.getItemWeight();
        }
        for (LootItem item : this.recyclerWhitelist) {
            this.generalTotalWeight += item.getItemWeight();
        }
    }

    public int getTotalListWeight() {
        return this.generalTotalWeight;
    }

    public void setLootSources(String[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            this.generalLootSources.add(sources[i]);
        }
    }
}

