/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntitySonicWeapon
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    public long setpitch;
    public long setvolume;
    public static final long MAXBROWNNOTE = 64L;
    public static final long BATKILL = 80000L;
    public static final long OMINOUS = 16L;
    public static final long DOGWHISTLE = 40000L;
    public static final long LRAD = 2400L;
    public static final long LETHALVOLUME = 100000000L;
    public static final long BRICKDESTROY = 1000000L;
    public static final long LRADVOLUME = 1260L;
    public static final long SHATTERGLASS = 118680L;
    public static final long BREAKWOOD = 475410L;
    public static final long LUNGDAMAGE = 2971000L;
    public static final long BRAINDAMAGE = 3906200L;
    public static final long EYEDAMAGE = 1807500L;
    public static final long SILVERFISHKILL = 400000L;
    public static final long REFERENCE = 1000000000000L;
    public static final int fudge = 100;
    public static final int FALLOFF = 16384;
    public static final long INTENSITYPERTORQUE = 0x200000000000L;
    public static final int HZPEROMEGA = 8192;
    public static final boolean ENABLEFREQ = false;
    public static final boolean DECIBELMODE = true;
    public int brownrange;
    public int batrange;
    public int ominousrange;
    public int dogrange;
    public int lradrange;
    public int killrange;
    public int brickrange;
    public int glassrange;
    public int woodrange;
    public int lungrange;
    public int brainrange;
    public int eyerange;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.setpitch > this.getMaxPitch()) {
            this.setpitch = this.getMaxPitch();
        }
        if (this.setvolume > this.getMaxVolume()) {
            this.setvolume = this.getMaxVolume();
        }
        this.applyEffects(world, x, y, z);
        if (this.tickcount >= 10) {
            SoundRegistry.SONIC.playSoundAtBlock(world, x, y, z);
            this.tickcount = 0;
        }
    }

    public void applyEffects(World world, int x, int y, int z) {
        this.testKill(world, x, y, z);
        this.breakBrick(world, x, y, z);
        this.testLung(world, x, y, z);
        this.testEye(world, x, y, z);
        this.testBrain(world, x, y, z);
        this.killSilverfish(world, x, y, z);
    }

    private void killSilverfish(World world, int x, int y, int z) {
        if (this.getVolume() < 400000L) {
            return;
        }
        int range = (int)(6.0 * (double)this.getVolume() / 400000.0);
        if (range > 20) {
            range = 20;
        }
        for (int i = 0; i < range; ++i) {
            int bz;
            int by;
            int bx = x - range + rand.nextInt(range + 1);
            if (world.func_147439_a(bx, by = y - range + rand.nextInt(range + 1), bz = z - range + rand.nextInt(range + 1)) != Blocks.field_150418_aU) continue;
            int metadata = world.func_72805_g(bx, by, bz);
            switch (metadata) {
                case 0: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150348_b);
                    break;
                }
                case 1: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150347_e);
                    break;
                }
                case 2: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150417_aV);
                }
            }
            world.func_72908_a((double)bx + 0.5, (double)by + 0.5, (double)bz + 0.5, "mob.silverfish.kill", 1.0f, 1.0f);
            ReikaWorldHelper.splitAndSpawnXP((World)world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (int)new EntitySilverfish((World)world).field_70728_aV);
        }
    }

    public void testEye(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : inbox) {
            boolean vuln = true;
            if (ent instanceof EntityPlayer && !this.isPlayerVulnerable((EntityPlayer)ent)) {
                vuln = false;
            }
            if (!vuln || !(100.0 * ReikaPhysicsHelper.inverseSquare((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5), (double)this.getVolume()) >= 1807500.0)) continue;
            ent.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 20, 0));
            if (!(ent instanceof EntityCreature)) continue;
        }
    }

    public void testBrain(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : inbox) {
            AxisAlignedBB nearmob;
            Entity target;
            boolean vuln = true;
            if (ent instanceof EntityPlayer && !this.isPlayerVulnerable((EntityPlayer)ent)) {
                vuln = false;
            }
            if (!vuln || !(100.0 * ReikaPhysicsHelper.inverseSquare((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5), (double)this.getVolume()) >= 3906200.0)) continue;
            ent.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 10));
            ent.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 20, 3));
            ent.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 1));
            if (ent instanceof EntityAnimal) {
                EntityAnimal ani = (EntityAnimal)ent;
                ani.func_70661_as().func_75499_g();
                if (ani.func_70661_as().func_75500_f()) {
                    double randx = ani.field_70165_t - 8.0 + (double)rand.nextInt(17);
                    double randz = ani.field_70161_v - 8.0 + (double)rand.nextInt(17);
                    int randy = world.func_72825_h((int)randx, (int)randz);
                    PathEntity path = ani.func_70661_as().func_75488_a(randx, (double)randy, randz);
                    ani.func_70661_as().func_75484_a(path, (double)0.2f);
                }
            }
            if (!(ent instanceof EntityMob) || !((target = world.func_72857_a(EntityMob.class, nearmob = AxisAlignedBB.func_72330_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v).func_72314_b(10.0, 10.0, 10.0), (Entity)ent)) instanceof EntityMob)) continue;
            ((EntityMob)ent).func_70624_b((EntityLivingBase)target);
            ((EntityMob)ent).func_70784_b(target);
            ent.func_70604_c((EntityLivingBase)target);
            ent.func_130011_c(target);
        }
    }

    public void testLung(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : inbox) {
            boolean vuln = true;
            if (ent instanceof EntityPlayer && !this.isPlayerVulnerable((EntityPlayer)ent)) {
                vuln = false;
            }
            if (!vuln || !(ReikaPhysicsHelper.inverseSquare((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5), (double)this.getVolume()) >= 2971000.0) || rand.nextInt(40) != 0) continue;
            ent.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public void breakBrick(World world, int x, int y, int z) {
    }

    public void testKill(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : inbox) {
            boolean vuln = true;
            if (ent instanceof EntityPlayer && !this.isPlayerVulnerable((EntityPlayer)ent)) {
                vuln = false;
            }
            if (!vuln || !(ReikaPhysicsHelper.inverseSquare((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5), (double)this.getVolume()) >= 1.0E8)) continue;
            ent.func_70097_a(DamageSource.field_76380_i, 2.1474836E9f);
        }
    }

    public long getMaxPitch() {
        return this.omega * 8192;
    }

    public long getMaxVolume() {
        return 0x200000000000L * (long)this.torque;
    }

    public long getVolume() {
        long maxvol = this.getMaxVolume();
        if (this.setvolume > maxvol) {
            return maxvol / 1000000L;
        }
        return this.setvolume / 1000000L;
    }

    public long getPitch() {
        long maxpitch = this.getMaxPitch();
        if (this.setpitch > maxpitch) {
            return maxpitch;
        }
        return this.setpitch;
    }

    @Override
    public int getRange() {
        if (this != null) {
            return 16;
        }
        int overpower = (int)(this.power - this.MINPOWER) / 16384;
        if (overpower > ConfigRegistry.SONICRANGE.getValue()) {
            return ConfigRegistry.SONICRANGE.getValue();
        }
        return overpower;
    }

    private boolean isPlayerVulnerable(EntityPlayer ep) {
        if (ep.field_71075_bZ.field_75098_d) {
            return false;
        }
        return ep.field_71071_by.field_70460_b[3] == null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74772_a("setfrequency", this.setpitch);
        NBT.func_74772_a("setvolume", this.setvolume);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setpitch = NBT.func_74763_f("setfrequency");
        this.setvolume = NBT.func_74763_f("setvolume");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SONICWEAPON;
    }

    @Override
    public int getMaxRange() {
        return Math.max(64, ConfigRegistry.SONICRANGE.getValue());
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

