/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.ShaftPowerBus;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoryIOMachine;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBusController;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPowerBus
extends TileEntityInventoryIOMachine
implements InertIInv,
BreakAction,
ComplexIO {
    private static final boolean ALLOW_VERTICAL_CHAINS = true;
    private boolean[] modes = new boolean[4];
    private ForgeDirection inputSide;
    private ShaftPowerBus bus;
    private int hubX = Integer.MIN_VALUE;
    private int hubY = Integer.MIN_VALUE;
    private int hubZ = Integer.MIN_VALUE;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.POWERBUS;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntityBusController hub;
        MachineRegistry m;
        if (this.bus == null && this.hasHubCoordinates() && (m = MachineRegistry.getMachine((IBlockAccess)world, this.hubX, this.hubY, this.hubZ)) == MachineRegistry.BUSCONTROLLER && (hub = (TileEntityBusController)world.func_147438_o(this.hubX, this.hubY, this.hubZ)) != null) {
            ShaftPowerBus bus = hub.getBus();
            this.configureBusData(bus);
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (!this.canHaveItemInSlot(dir) || this.getAdjacentTileEntity(dir) == null) continue;
            int speed = this.getSpeedToSide(dir);
            int torque = this.getTorqueToSide(dir);
            this.writeToPowerReceiver(dir, speed, torque);
        }
    }

    public boolean canHaveItemInSlot(ForgeDirection dir) {
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        return m != MachineRegistry.BUSCONTROLLER && m != MachineRegistry.POWERBUS;
    }

    private boolean hasHubCoordinates() {
        return this.hubX != Integer.MIN_VALUE && this.hubY != Integer.MIN_VALUE && this.hubZ != Integer.MIN_VALUE;
    }

    public int getAbsRatio(ForgeDirection dir) {
        if (dir.offsetY != 0) {
            return 0;
        }
        return this.getRatioFromItem(this.inv[dir.ordinal() - 2]);
    }

    private int getRatioFromItem(ItemStack is) {
        if (is == null) {
            return 0;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.gearunit)) {
            return 2;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.gearunit4)) {
            return 4;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.gearunit8)) {
            return 8;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.gearunit16)) {
            return 16;
        }
        if (ItemRegistry.GEARUNITS.matchItem(is)) {
            return ReikaMathLibrary.intpow2((int)2, (int)(1 + is.func_77960_j() % 4));
        }
        if (is.func_77973_b() == Items.field_151055_y) {
            return 1;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.stonerod)) {
            return 1;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftitem)) {
            return 1;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.diamondshaft)) {
            return 1;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.bedrockshaft)) {
            return 1;
        }
        return 0;
    }

    public boolean insertItem(ItemStack is, ForgeDirection side) {
        if (this.getRatioFromItem(is) > 0 && this.inv[side.ordinal() - 2] == null) {
            this.inv[side.ordinal() - 2] = is.func_77946_l();
            return true;
        }
        return false;
    }

    public boolean isSideSpeedMode(ForgeDirection dir) {
        return this.modes[dir.ordinal() - 2];
    }

    public void setMode(ForgeDirection dir, boolean speed) {
        this.modes[dir.ordinal() - 2] = speed;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean canOutputToSide(ForgeDirection dir) {
        return !this.isReceivingFromSide(dir) && this.hasValidItem(dir);
    }

    public boolean isReceivingFromSide(ForgeDirection dir) {
        return dir == this.getInputSide();
    }

    private boolean hasValidItem(ForgeDirection dir) {
        return this.getAbsRatio(dir) != 0;
    }

    public long getPowerPerSide() {
        return this.getInputPower() / (long)this.bus.getTotalOutputSides();
    }

    public long getInputPower() {
        return this.bus != null ? this.bus.getInputPower() : 0L;
    }

    public int getInputTorque() {
        return this.bus != null ? this.bus.getInputTorque() : 0;
    }

    public int getTorquePerSide() {
        return this.bus != null ? this.getInputTorque() / this.bus.getTotalOutputSides() : 0;
    }

    @Override
    public int getTorqueToSide(ForgeDirection dir) {
        int trq;
        if (dir == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int tbase = this.getTorquePerSide();
        int ratio = this.getAbsRatio(dir);
        if (ratio == 0) {
            return 0;
        }
        int n = trq = this.isSideSpeedMode(dir) ? tbase / ratio : tbase * ratio;
        if (this.verifyTorque(trq, dir)) {
            return trq;
        }
        this.breakItem(dir);
        return 0;
    }

    @Override
    public int getSpeedToSide(ForgeDirection dir) {
        int spd;
        if (this.bus == null) {
            return 0;
        }
        if (dir == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int sbase = this.bus.getSpeed();
        int ratio = this.getAbsRatio(dir);
        if (ratio == 0) {
            return 0;
        }
        int n = spd = this.isSideSpeedMode(dir) ? sbase * ratio : sbase / ratio;
        if (this.verifySpeed(spd, dir)) {
            return spd;
        }
        this.breakItem(dir);
        return 0;
    }

    private boolean verifySpeed(int speed, ForgeDirection dir) {
        ItemStack is = this.inv[dir.ordinal() - 2];
        MaterialRegistry mat = MaterialRegistry.getMaterialFromItem(is);
        return mat.getMaxShaftSpeed() >= (double)speed;
    }

    private boolean verifyTorque(int torque, ForgeDirection dir) {
        ItemStack is = this.inv[dir.ordinal() - 2];
        MaterialRegistry mat = MaterialRegistry.getMaterialFromItem(is);
        return mat.getMaxShaftTorque() >= (double)torque;
    }

    private void breakItem(ForgeDirection dir) {
        this.inv[dir.ordinal() - 2] = null;
        for (int i = 0; i < 3; ++i) {
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.break", (float)2.0f, (float)1.0f);
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return false;
    }

    public ForgeDirection getInputSide() {
        return this.inputSide != null ? this.inputSide : ForgeDirection.EAST;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.inputSide = this.dirs[NBT.func_74762_e("in")];
        this.modes = ReikaArrayHelper.booleanFromByteBitflags((byte)NBT.func_74771_c("mode"), (int)4);
        this.hubX = NBT.func_74762_e("hx");
        this.hubY = NBT.func_74762_e("hy");
        this.hubZ = NBT.func_74762_e("hz");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("in", this.getInputSide().ordinal());
        NBT.func_74774_a("mode", ReikaArrayHelper.booleanToByteBitflags((boolean[])this.modes));
        NBT.func_74768_a("hx", this.hubX);
        NBT.func_74768_a("hy", this.hubY);
        NBT.func_74768_a("hz", this.hubZ);
    }

    public void findNetwork(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            TileEntityIOMachine te;
            ShaftPowerBus bus;
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m == MachineRegistry.BUSCONTROLLER && (bus = ((TileEntityBusController)(te = (TileEntityBusController)world.func_147438_o(dx, dy, dz))).getBus()) != null) {
                this.configureBusData(bus);
                this.inputSide = dir;
                return;
            }
            if (m != MachineRegistry.POWERBUS || (bus = ((TileEntityPowerBus)(te = (TileEntityPowerBus)world.func_147438_o(dx, dy, dz))).getBus()) == null) continue;
            this.configureBusData(bus);
            this.inputSide = dir;
            return;
        }
    }

    private void configureBusData(ShaftPowerBus bus) {
        bus.addBlock(this);
        this.bus = bus;
        TileEntityBusController hub = bus.getController();
        this.hubX = hub.field_145851_c;
        this.hubY = hub.field_145848_d;
        this.hubZ = hub.field_145849_e;
    }

    private void removeFromBus() {
        if (this.bus != null) {
            this.bus.removeBlock(this);
        }
    }

    public ShaftPowerBus getBus() {
        return this.bus;
    }

    public void clearBus() {
        this.bus = null;
        this.hubX = Integer.MIN_VALUE;
        this.hubY = Integer.MIN_VALUE;
        this.hubZ = Integer.MIN_VALUE;
    }

    @Override
    public boolean isWritingTo(PowerSourceTracker te) {
        for (int i = 2; i < 6; ++i) {
            if (!this.canOutputToSide(this.dirs[i]) || !this.matchTile(te, this.dirs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return this.bus != null && this.bus.getController() != null ? this.bus.getController().getPowerSources(io, caller) : new PowerSourceList();
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    public void breakBlock() {
        this.removeFromBus();
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (dir == this.read) {
            c.add(this.getAdjacentTileEntity(this.write));
        }
    }
}

