/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.Connectable;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TransmissionReceiver;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBeltHub
extends TileEntityPowerReceiver
implements PowerGenerator,
SimpleProvider,
TransmissionReceiver,
Connectable,
BreakAction {
    public boolean isEmitting;
    private int wetTimer = 0;
    private boolean isSlippingTorque;
    private boolean isSlippingOmega;
    private int[] source = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] target = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private StepTimer sound = new StepTimer(26);

    public boolean isSplitting() {
        return this.func_145832_p() >= 6;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta % 6);
        this.sound.update();
        if (this.isEmitting) {
            this.write = this.read;
            this.write2 = this.isSplitting() ? this.read.getOpposite() : null;
            this.read = null;
            this.copyPower();
        } else {
            this.write = this.isSplitting() ? this.read.getOpposite() : null;
            this.getPower(false);
            if (this.isSplitting()) {
                this.power /= 2L;
                this.torque /= 2;
            }
        }
        if (this.power > 0L) {
            this.playSound(world, x, y, z);
        }
        if (world.func_72896_J() && world.func_72951_B(x, y + 1, z) && world.func_82737_E() % 1024L == 0L) {
            this.makeWet();
        }
        if (this.wetTimer > 0 && this.power > 0L) {
            --this.wetTimer;
        }
    }

    private void playSound(World world, int x, int y, int z) {
        if (this.sound.checkCap()) {
            SoundRegistry.BELT.playSoundAtBlock(world, x, y, z, 0.6f, 1.0f);
        }
    }

    public final boolean areInSamePlane(TileEntityBeltHub belt) {
        int meta = this.func_145832_p() % 6;
        int meta2 = belt.func_145832_p() % 6;
        if (meta == 0 || meta == 1) {
            return meta2 == 0 || meta2 == 1;
        }
        if (meta == 2 || meta == 3) {
            return meta2 == 2 || meta2 == 3;
        }
        if (meta == 4 || meta == 5) {
            return meta2 == 4 || meta2 == 5;
        }
        return false;
    }

    public final void reset() {
        this.source = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        this.target = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    }

    public final void resetOther() {
        if (!this.isEmitting) {
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.target[0], this.target[1], this.target[2]);
            if (m == this.getMachine()) {
                TileEntityBeltHub te = (TileEntityBeltHub)this.field_145850_b.func_147438_o(this.target[0], this.target[1], this.target[2]);
                te.reset();
            }
        } else {
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.source[0], this.source[1], this.source[2]);
            if (m == this.getMachine()) {
                TileEntityBeltHub te = (TileEntityBeltHub)this.field_145850_b.func_147438_o(this.source[0], this.source[1], this.source[2]);
                te.reset();
            }
        }
    }

    public final boolean canConnect(int x, int y, int z) {
        int dx = x - this.field_145851_c;
        int dy = y - this.field_145848_d;
        int dz = z - this.field_145849_e;
        boolean[] blArray = new boolean[3];
        blArray[0] = dx != 0;
        blArray[1] = dy != 0;
        boolean bl = blArray[2] = dz != 0;
        if (!ReikaMathLibrary.nBoolsAreTrue((int)1, (boolean[])blArray)) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (dx > 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx < 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy > 0) {
            dir = ForgeDirection.UP;
        }
        if (dy < 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz > 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz < 0) {
            dir = ForgeDirection.NORTH;
        }
        if (dir == null) {
            return false;
        }
        if (!this.isValidDirection(dir)) {
            return false;
        }
        for (int i = 1; i < Math.abs(dx + dy + dz); ++i) {
            int xi = this.field_145851_c + dir.offsetX * i;
            int yi = this.field_145848_d + dir.offsetY * i;
            int zi = this.field_145849_e + dir.offsetZ * i;
            Block id = this.field_145850_b.func_147439_a(xi, yi, zi);
            if (ReikaWorldHelper.softBlocks((IBlockAccess)this.field_145850_b, (int)xi, (int)yi, (int)zi)) continue;
            return false;
        }
        return true;
    }

    public final boolean shouldRenderBelt() {
        if (this.isEmitting) {
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.source[0], this.source[1], this.source[2]);
            return m == this.getMachine() && this.canConnect(this.source[0], this.source[1], this.source[2]);
        }
        if (this.target[0] != Integer.MIN_VALUE && this.target[1] != Integer.MIN_VALUE && this.target[2] != Integer.MIN_VALUE) {
            return this.canConnect(this.target[0], this.target[1], this.target[2]);
        }
        return false;
    }

    public final boolean setTarget(World world, int x, int y, int z) {
        if (!this.canConnect(x, y, z)) {
            return false;
        }
        if (this.target[0] != Integer.MIN_VALUE && this.target[1] != Integer.MIN_VALUE && this.target[2] != Integer.MIN_VALUE) {
            return false;
        }
        if (!this.areInSamePlane((TileEntityBeltHub)this.field_145850_b.func_147438_o(x, y, z))) {
            return false;
        }
        this.target[0] = x;
        this.target[1] = y;
        this.target[2] = z;
        return true;
    }

    public final boolean setSource(World world, int x, int y, int z) {
        if (!this.canConnect(x, y, z)) {
            return false;
        }
        if (this.source[0] != Integer.MIN_VALUE && this.source[1] != Integer.MIN_VALUE && this.source[2] != Integer.MIN_VALUE) {
            return false;
        }
        if (!this.areInSamePlane((TileEntityBeltHub)this.field_145850_b.func_147438_o(x, y, z))) {
            return false;
        }
        this.source[0] = x;
        this.source[1] = y;
        this.source[2] = z;
        return true;
    }

    public int getMaxTorque() {
        return 8192;
    }

    public int getMaxSmoothSpeed() {
        return 8192;
    }

    public int getTorque(int input) {
        int max = this.isWet() ? this.getMaxTorque() / 4 : this.getMaxTorque();
        this.isSlippingTorque = input > max;
        int torque = Math.min(input, max);
        return this.isSplitting() ? torque / 2 : torque;
    }

    public int getOmega(int input) {
        int s = this.isWet() ? this.getMaxSmoothSpeed() / 4 : this.getMaxSmoothSpeed();
        this.isSlippingOmega = input > s;
        int speed = input <= s ? input : (int)((double)s + Math.sqrt(input - s));
        return speed;
    }

    private void copyPower() {
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.source[0], this.source[1], this.source[2]);
        if (m == this.getMachine() && this.canConnect(this.source[0], this.source[1], this.source[2])) {
            TileEntityBeltHub tile = (TileEntityBeltHub)this.field_145850_b.func_147438_o(this.source[0], this.source[1], this.source[2]);
            this.omega = this.getOmega(tile.omega);
            this.torque = this.getTorque(tile.torque);
            this.power = (long)this.omega * (long)this.torque;
        } else {
            if (this.omega > 0) {
                this.omega = (int)((double)this.omega * 0.98);
            } else {
                this.torque = 0;
            }
            this.power = (long)this.omega * (long)this.torque;
        }
    }

    public final ForgeDirection getBeltDirection() {
        int dx = 0;
        int dy = 0;
        int dz = 0;
        if (this.isEmitting) {
            dx = this.field_145851_c - this.source[0];
            dy = this.field_145848_d - this.source[1];
            dz = this.field_145849_e - this.source[2];
        } else {
            dx = this.field_145851_c - this.target[0];
            dy = this.field_145848_d - this.target[1];
            dz = this.field_145849_e - this.target[2];
        }
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (dx < 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx > 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy < 0) {
            dir = ForgeDirection.UP;
        }
        if (dy > 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz < 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz > 0) {
            dir = ForgeDirection.NORTH;
        }
        return dir;
    }

    public final int getDistanceToTarget() {
        if (this.isEmitting) {
            int dx = this.field_145851_c - this.source[0];
            int dy = this.field_145848_d - this.source[1];
            int dz = this.field_145849_e - this.source[2];
            return Math.abs(dx + dy + dz);
        }
        int dx = this.field_145851_c - this.target[0];
        int dy = this.field_145848_d - this.target[1];
        int dz = this.field_145849_e - this.target[2];
        return Math.abs(dx + dy + dz);
    }

    public final boolean isValidDirection(ForgeDirection dir) {
        switch (this.func_145832_p() % 6) {
            case 0: 
            case 1: {
                return dir.offsetX == 0;
            }
            case 2: 
            case 3: {
                return dir.offsetZ == 0;
            }
            case 4: 
            case 5: {
                return dir.offsetY == 0;
            }
        }
        return false;
    }

    @Override
    public final boolean canProvidePower() {
        return this.isEmitting || this.isSplitting();
    }

    @Override
    public final PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        if (this.isEmitting) {
            TileEntityBeltHub tile = (TileEntityBeltHub)this.field_145850_b.func_147438_o(this.source[0], this.source[1], this.source[2]);
            return tile != null ? tile.getPowerSources(io, caller) : new PowerSourceList();
        }
        return PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BELT;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public final long getMaxPower() {
        return this.isSplitting() ? this.power / 2L : this.power;
    }

    @Override
    public final long getCurrentPower() {
        return this.isSplitting() ? this.power / 2L : this.power;
    }

    public final boolean isWet() {
        return this.wetTimer > 0;
    }

    public final void makeWet() {
        this.wetTimer = Math.min(this.wetTimer + 3600, 18000);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("emit", this.isEmitting);
        NBT.func_74783_a("tg", this.target);
        NBT.func_74783_a("src", this.source);
        NBT.func_74768_a("wet", this.wetTimer);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isEmitting = NBT.func_74767_n("emit");
        this.source = NBT.func_74759_k("src");
        this.target = NBT.func_74759_k("tg");
        this.wetTimer = NBT.func_74762_e("wet");
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public final int getTargetX() {
        return this.target[0];
    }

    public final int getTargetY() {
        return this.target[1];
    }

    public final int getTargetZ() {
        return this.target[2];
    }

    @Override
    public final int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public final int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public final int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    public int[] getBeltColor() {
        return new int[]{192, 120, 70};
    }

    public ItemStack getBeltItem() {
        return ItemStacks.belt.func_77946_l();
    }

    public boolean isEmitting() {
        return this.isEmitting;
    }

    public final void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            int num = this.getDistanceToTarget() - 1;
            num = Math.min(num, ItemStacks.belt.func_77976_d());
            if (!this.shouldRenderBelt()) {
                num = 0;
            }
            for (int i = 0; i < num; ++i) {
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getBeltItem());
            }
            this.resetOther();
        }
    }

    @Override
    public final void getOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        TileEntity te = this.field_145850_b.func_147438_o(this.target[0], this.target[1], this.target[2]);
        if (te instanceof TileEntityBeltHub) {
            TileEntityBeltHub belt = (TileEntityBeltHub)te;
            c.add(belt.getAdjacentTileEntity(belt.write));
            c.add(belt.getAdjacentTileEntity(belt.write2));
        }
    }

    public boolean isSlipping() {
        return this.isSlippingOmega || this.isSlippingTorque;
    }
}

