/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Base.BlockTEBase;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Interfaces.Registry.BlockEnum;
import Reika.RotaryCraft.Base.BlockBasicMachine;
import Reika.RotaryCraft.Blocks.BlockAdvGear;
import Reika.RotaryCraft.Blocks.BlockBeam;
import Reika.RotaryCraft.Blocks.BlockBedrockSlice;
import Reika.RotaryCraft.Blocks.BlockBlastGlass;
import Reika.RotaryCraft.Blocks.BlockBlastPane;
import Reika.RotaryCraft.Blocks.BlockCanola;
import Reika.RotaryCraft.Blocks.BlockDMIMachine;
import Reika.RotaryCraft.Blocks.BlockDMMachine;
import Reika.RotaryCraft.Blocks.BlockDMachine;
import Reika.RotaryCraft.Blocks.BlockDeco;
import Reika.RotaryCraft.Blocks.BlockDecoTank;
import Reika.RotaryCraft.Blocks.BlockEngine;
import Reika.RotaryCraft.Blocks.BlockFlywheel;
import Reika.RotaryCraft.Blocks.BlockGPR;
import Reika.RotaryCraft.Blocks.BlockGearbox;
import Reika.RotaryCraft.Blocks.BlockIMachine;
import Reika.RotaryCraft.Blocks.BlockLightBridge;
import Reika.RotaryCraft.Blocks.BlockLightblock;
import Reika.RotaryCraft.Blocks.BlockMIMachine;
import Reika.RotaryCraft.Blocks.BlockMMachine;
import Reika.RotaryCraft.Blocks.BlockMachine;
import Reika.RotaryCraft.Blocks.BlockMiningPipe;
import Reika.RotaryCraft.Blocks.BlockModEngine;
import Reika.RotaryCraft.Blocks.BlockPiping;
import Reika.RotaryCraft.Blocks.BlockShaft;
import Reika.RotaryCraft.Blocks.BlockSolar;
import Reika.RotaryCraft.Blocks.BlockTrans;
import Reika.RotaryCraft.Items.ItemBlockDeco;
import Reika.RotaryCraft.Items.ItemBlockDecoTank;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.RotaryNames;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum BlockRegistry implements BlockEnum
{
    ADVANCEDGEAR(BlockAdvGear.class, 0),
    DIR(BlockDMachine.class, 0),
    DIRMODELINV(BlockDMIMachine.class, 0),
    DIRMODEL(BlockDMMachine.class, 0),
    ENGINE(BlockEngine.class, 0),
    GPR(BlockGPR.class, 0),
    FLYWHEEL(BlockFlywheel.class, 0),
    GEARBOX(BlockGearbox.class, 0),
    INV(BlockIMachine.class, 0),
    BASIC(BlockMachine.class, 0),
    MODELINV(BlockMIMachine.class, 0),
    MODEL(BlockMMachine.class, 0),
    PIPING(BlockPiping.class, 0),
    SHAFT(BlockShaft.class, 0),
    TRANS(BlockTrans.class, 0),
    MODELINV2(BlockMIMachine.class, 1),
    SOLAR(BlockSolar.class, 0),
    BCENGINE(BlockModEngine.class, 0),
    MODEL2(BlockMMachine.class, 1),
    DIRMODEL2(BlockDMMachine.class, 1),
    DECO(BlockDeco.class, "block.deco", ItemBlockDeco.class),
    CANOLA(BlockCanola.class, "block.canola"),
    LIGHT(BlockLightblock.class, "block.light"),
    BEAM(BlockBeam.class, "block.beam"),
    BRIDGE(BlockLightBridge.class, "block.bridge"),
    MININGPIPE(BlockMiningPipe.class, "block.miningpipe"),
    BLASTGLASS(BlockBlastGlass.class, "block.blastglass"),
    BLASTPANE(BlockBlastPane.class, "block.blastpane"),
    BEDROCKSLICE(BlockBedrockSlice.class, "block.bedrockslice"),
    DECOTANK(BlockDecoTank.class, "block.decotank", ItemBlockDecoTank.class);

    private final Class block;
    private final Class itemBlock;
    private final int offset;
    private final String name;
    public static final BlockRegistry[] blockList;
    private static final HashMap<Item, BlockRegistry> itemMap;
    private static final HashMap<Block, BlockRegistry> IDMap;
    private static final PluralMap<BlockRegistry> classMap;

    private BlockRegistry(Class cl, String name) {
        this(cl, null, -1, name);
    }

    private BlockRegistry(Class cl, String name, Class<? extends ItemBlock> item) {
        this(cl, item, -1, name);
    }

    private BlockRegistry(Class cl, int offset) {
        this(cl, null, offset, "");
    }

    private BlockRegistry(Class cl, Class<? extends ItemBlock> item, int offset) {
        this(cl, item, offset, "");
    }

    private BlockRegistry(Class cl, int offset, String name) {
        this(cl, null, offset, name);
    }

    private BlockRegistry(Class cl, Class<? extends ItemBlock> item, int offset, String name) {
        this.block = cl;
        this.itemBlock = item;
        this.offset = offset;
        this.name = name;
    }

    public static BlockRegistry getBlock(Block b) {
        return IDMap.get(b);
    }

    public static boolean isMachineBlock(Block id) {
        BlockRegistry br = BlockRegistry.getBlock(id);
        return br != null && br.isMachine();
    }

    public static boolean isTechnicalBlock(Block id) {
        BlockRegistry br = BlockRegistry.getBlock(id);
        return br != null && br.isTechnical();
    }

    static BlockRegistry getBlockFromClassAndOffset(Class<? extends Block> c, int i) {
        return (BlockRegistry)((Object)classMap.get(new Object[]{c, i}));
    }

    public Class getObjectClass() {
        return this.block;
    }

    public Block getBlockInstance() {
        return RotaryCraft.blocks[this.ordinal()];
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    private String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    public String getBasicName() {
        return this.isMachine() ? "(TECHNICAL BLOCK) " + this.block.getSimpleName() + ":" + this.ordinal() : this.getLocalizedName();
    }

    public boolean isFundamentalType() {
        return BlockBasicMachine.class.isAssignableFrom(this.block);
    }

    public boolean isTechnical() {
        switch (this) {
            case DECO: 
            case BLASTGLASS: 
            case BLASTPANE: 
            case DECOTANK: {
                return false;
            }
        }
        return true;
    }

    public boolean isMachine() {
        return BlockTEBase.class.isAssignableFrom(this.block);
    }

    public Class[] getConstructorParamTypes() {
        Class[] classArray;
        if (this.isMachine()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Material.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public Object[] getConstructorParams() {
        Object[] objectArray;
        if (this.isMachine()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = Material.field_151573_f;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public String getMultiValuedName(int meta) {
        if (!this.hasMultiValuedName()) {
            return this.getBasicName();
        }
        switch (this) {
            case DECO: {
                return StatCollector.func_74838_a((String)RotaryNames.blockNames[meta]);
            }
            case DECOTANK: {
                return StatCollector.func_74838_a((String)"block.decotank.0");
            }
        }
        throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "No multiname for " + (Object)((Object)this) + "!");
    }

    public boolean hasMultiValuedName() {
        return this.getNumberMetadatas() > 1;
    }

    public int getNumberMetadatas() {
        switch (this) {
            case DECO: {
                return RotaryNames.blockNames.length;
            }
            case DECOTANK: {
                return 16;
            }
        }
        return 1;
    }

    public Class<? extends ItemBlock> getItemBlock() {
        return this.itemBlock;
    }

    public boolean hasItemBlock() {
        return this.itemBlock != null;
    }

    public boolean isDummiedOut() {
        return this.block == null;
    }

    public Item getItem() {
        return Item.func_150898_a((Block)this.getBlockInstance());
    }

    public ItemStack getStackOf() {
        return this.getStackOfMetadata(0);
    }

    public ItemStack getStackOfMetadata(int meta) {
        return new ItemStack(this.getBlockInstance(), 1, meta);
    }

    public ItemStack getCraftedProduct(int amt) {
        return this.getCraftedMetadataProduct(amt, 0);
    }

    public ItemStack getCraftedMetadataProduct(int amt, int meta) {
        return new ItemStack(this.getBlockInstance(), amt, meta);
    }

    public static BlockRegistry getFromItem(ItemStack is) {
        return itemMap.get(is.func_77973_b());
    }

    public static void loadMappings() {
        for (int i = 0; i < blockList.length; ++i) {
            BlockRegistry block = blockList[i];
            Block b = block.getBlockInstance();
            itemMap.put(Item.func_150898_a((Block)b), block);
            IDMap.put(block.getBlockInstance(), block);
            classMap.put((Object)block, new Object[]{block.block, block.offset});
        }
    }

    static {
        blockList = BlockRegistry.values();
        itemMap = new HashMap();
        IDMap = new HashMap();
        classMap = new PluralMap(2);
    }
}

