/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.Exception.ModReflectionException;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.AppEngHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.FactorizationHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.GalacticCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.LegacyMagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicaOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekanismHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MimicryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.QuantumOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RailcraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumOreHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.VeryLegacyMagicCropHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreForcer {
    public static final OreForcer instance = new OreForcer();

    private OreForcer() {
    }

    public void forceCompatibility() {
        for (int i = 0; i < ModList.modList.length; ++i) {
            ModList mod = ModList.modList[i];
            if (!mod.isLoaded()) continue;
            try {
                this.force(mod);
                continue;
            }
            catch (NullPointerException e) {
                RotaryCraft.logger.logError((Object)("Could not force compatibility with " + mod + ". Reason: "));
                e.printStackTrace();
                continue;
            }
            catch (ClassCastException e) {
                RotaryCraft.logger.logError((Object)("Could not force compatibility with " + mod + ". Reason: "));
                e.printStackTrace();
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RotaryCraft.logger.logError((Object)("Could not force compatibility with " + mod + ". Reason: "));
                e.printStackTrace();
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                RotaryCraft.logger.logError((Object)("Could not force compatibility with " + mod + ". Reason: "));
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                RotaryCraft.logger.logError((Object)("Could not force compatibility with " + mod + ". Reason: "));
                e.printStackTrace();
                continue;
            }
            catch (ModReflectionException e) {
                RotaryCraft.logger.logError((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void force(ModList api) {
        if (!api.isReikasMod()) {
            RotaryCraft.logger.log((Object)("Forcing compatibility with " + api));
        }
        switch (api) {
            case APPENG: {
                this.intercraftQuartz();
                break;
            }
            case FORESTRY: {
                this.intercraftApatite();
                break;
            }
            case THAUMCRAFT: {
                if (ConfigRegistry.MODORES.getState()) {
                    this.registerThaumcraft();
                }
                this.intercraftThaumcraft();
                break;
            }
            case MFFS: {
                this.intercraftForcicium();
                break;
            }
            case MEKANISM: {
                this.registerOsmium();
                break;
            }
            case DARTCRAFT: {
                if (ConfigRegistry.MODORES.getState()) {
                    this.registerDart();
                }
                this.intercraftDart();
                this.breakForceWrench();
                break;
            }
            case ARSMAGICA: {
                if (ConfigRegistry.MODORES.getState()) {
                    this.registerMagica();
                }
                this.intercraftMagica();
                break;
            }
            case TRANSITIONAL: {
                this.intercraftMagmanite();
                break;
            }
            case RAILCRAFT: {
                this.intercraftFirestone();
                break;
            }
            case IC2: {
                this.convertUranium();
                break;
            }
            case MAGICCROPS: {
                if (ConfigRegistry.MODORES.getState()) {
                    this.registerEssence();
                }
                this.intercraftEssence();
                break;
            }
            case MIMICRY: {
                this.intercraftMimichite();
                break;
            }
            case FACTORIZATION: {
                this.intercraftDarkIron();
                break;
            }
            case QCRAFT: {
                if (ConfigRegistry.MODORES.getState()) {
                    this.registerQuantum();
                }
                this.intercraftQuantum();
                break;
            }
            case PROJRED: {
                this.intercraftPRGems();
                break;
            }
            case GALACTICRAFT: {
                this.intercraftSilicon();
                break;
            }
            case DRACONICEVO: {
                this.intercraftDraconium();
            }
        }
    }

    private void intercraftDraconium() {
        ItemStack dust = ReikaItemHelper.lookupItem((ModList)ModList.DRACONICEVO, (String)"draconiumDust", (int)0);
        if (dust == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.DRACONICEVO, "Null Item for Draconium");
        }
        GameRegistry.addShapelessRecipe((ItemStack)dust, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.DRACONIUM)});
    }

    private void intercraftSilicon() {
        Item id = GalacticCraftHandler.getInstance().basicItemID;
        if (id == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.GALACTICRAFT, "Null Item for Silicon");
        }
        ItemStack silicon = new ItemStack(id, 1, 2);
        GameRegistry.addShapelessRecipe((ItemStack)silicon, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.SILICON)});
    }

    private void intercraftPRGems() {
        ItemStack ruby = this.getPRGem("gemRuby");
        ItemStack sapphire = this.getPRGem("gemSapphire");
        ItemStack peridot = this.getPRGem("gemPeridot");
        if (ruby != null) {
            GameRegistry.addShapelessRecipe((ItemStack)ItemStacks.getModOreIngot(ModOreList.RUBY), (Object[])new Object[]{ruby});
        }
        if (sapphire != null) {
            GameRegistry.addShapelessRecipe((ItemStack)ItemStacks.getModOreIngot(ModOreList.SAPPHIRE), (Object[])new Object[]{sapphire});
        }
        if (peridot != null) {
            GameRegistry.addShapelessRecipe((ItemStack)ItemStacks.getModOreIngot(ModOreList.PERIDOT), (Object[])new Object[]{peridot});
        }
        RotaryCraft.logger.log((Object)"RotaryCraft gems can now be crafted into Project Red gems!");
    }

    private ItemStack getPRGem(String oredict) {
        ArrayList gems = OreDictionary.getOres((String)oredict);
        for (int i = 0; i < gems.size(); ++i) {
            ItemStack is = (ItemStack)gems.get(i);
            if (ItemRegistry.MODINGOTS.matchItem(is)) continue;
            return is;
        }
        return null;
    }

    private void registerQuantum() {
        QuantumOreHandler.getInstance().forceOreRegistration();
    }

    private void intercraftQuantum() {
        if (QuantumOreHandler.getInstance().dustID != null) {
            ItemStack ore = new ItemStack(QuantumOreHandler.getInstance().dustID, 1, 0);
            GameRegistry.addShapelessRecipe((ItemStack)ore, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.QUANTUM)});
            RotaryCraft.logger.log((Object)"RotaryCraft quantum dust can now be crafted into QCraft quantum dust!");
        }
    }

    private void intercraftDarkIron() {
        if (FactorizationHandler.getInstance().ingotID != null) {
            ItemStack ingot = new ItemStack(FactorizationHandler.getInstance().ingotID, 1, 0);
            GameRegistry.addShapelessRecipe((ItemStack)ingot, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.DARKIRON)});
            RotaryCraft.logger.log((Object)"RotaryCraft dark iron ingots can now be crafted into Factorization equivalents!");
        }
    }

    private void intercraftMimichite() {
        if (MimicryHandler.getInstance().itemID != null) {
            ItemStack ore = new ItemStack(MimicryHandler.getInstance().itemID, 1, 0);
            GameRegistry.addShapelessRecipe((ItemStack)ore, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.MIMICHITE)});
            RotaryCraft.logger.log((Object)"RotaryCraft mimichite items can now be crafted into Mimicry mimichite!");
        }
    }

    private void registerEssence() {
        ModHandlerBase h = ModList.MAGICCROPS.getHandler("Handler");
        if (h instanceof MagicCropHandler) {
            ((MagicCropHandler)h).registerEssence();
        }
        if (h instanceof LegacyMagicCropHandler) {
            ((LegacyMagicCropHandler)h).registerEssence();
        }
        if (h instanceof VeryLegacyMagicCropHandler) {
            ((VeryLegacyMagicCropHandler)h).registerEssence();
        }
    }

    private void intercraftEssence() {
        ItemStack ore = MagicCropHandler.EssenceType.ESSENCE.getEssence();
        if (ore != null) {
            GameRegistry.addShapelessRecipe((ItemStack)ore, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.ESSENCE)});
            RotaryCraft.logger.log((Object)"RotaryCraft essence items can now be crafted into Magic Crops essence!");
        } else {
            RotaryCraft.logger.logError((Object)"Could not find essence item, cannot add intercraft recipe!");
        }
    }

    private void convertUranium() {
        ItemStack u = IC2Handler.IC2Stacks.PURECRUSHEDU.getItem();
        if (u == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.IC2, "Null ItemStack for Uranium");
        }
        if (IC2Handler.IC2Stacks.IRIDIUM.getItem() == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.IC2, "Null Item for Iridium");
        }
        GameRegistry.addShapelessRecipe((ItemStack)IC2Handler.IC2Stacks.IRIDIUM.getItem(), (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.IRIDIUM)});
        RotaryCraft.logger.log((Object)"RotaryCraft iridium ingots can now be crafted into IC2 Iridium items!");
        GameRegistry.addShapelessRecipe((ItemStack)u, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.URANIUM)});
        RotaryCraft.logger.log((Object)"RotaryCraft uranium ingots can now be crafted into IC2 purified crushed uranium!");
    }

    private void intercraftFirestone() {
        Item item = RailcraftHandler.getInstance().firestoneID;
        if (item == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.RAILCRAFT, "Null ItemStack for Firestone");
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(item), (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.FIRESTONE)});
        RotaryCraft.logger.log((Object)"RotaryCraft firestone can now be crafted into RailCraft firestone!");
    }

    private void intercraftMagmanite() {
        Class trans = ModList.TRANSITIONAL.getItemClass();
        try {
            Field f = trans.getField("MagmaDrop");
            Item i = (Item)f.get(null);
            if (i == null) {
                throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.TRANSITIONAL, "Null ItemStack for Magmanite Drop");
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(i), (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.MAGMANITE)});
            RotaryCraft.logger.log((Object)"RotaryCraft magmanite can now be crafted into Transitional Assistance magmanite!");
        }
        catch (NoSuchFieldException e) {
            RotaryCraft.logger.logError((Object)"Transitional Assistance item field not found!");
        }
        catch (SecurityException e) {
            RotaryCraft.logger.logError((Object)("Cannot read Transitional Assistance items (Security Exception)! Magmanite not convertible!" + e.getMessage()));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            RotaryCraft.logger.logError((Object)"Illegal argument for reading Transitional Assistance items!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            RotaryCraft.logger.logError((Object)"Illegal access exception for reading Transitional Assistance items!");
            e.printStackTrace();
        }
    }

    private void intercraftMagica() {
        RotaryCraft.logger.log((Object)"Adding ore item conversion recipes!");
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            ModOreList o = ModOreList.oreList[i];
            if (!o.isArsMagica()) continue;
            ItemStack is = MagicaOreHandler.getInstance().getItem(o);
            if (is == null) {
                throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.ARSMAGICA, "Null ItemStack for Ars Magica " + o);
            }
            GameRegistry.addShapelessRecipe((ItemStack)is, (Object[])new Object[]{ItemStacks.getModOreIngot(o)});
            RotaryCraft.logger.log((Object)(o.displayName + " can now be crafted with RotaryCraft equivalents!"));
        }
    }

    private void registerMagica() {
        MagicaOreHandler.getInstance().forceOreRegistration();
    }

    private void registerOsmium() {
        if (MekanismHandler.getInstance().oreID == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.MEKANISM, "Null Item for Osmium");
        }
        OreDictionary.registerOre((String)"oreOsmium", (ItemStack)new ItemStack(MekanismHandler.getInstance().oreID, 1, 0));
    }

    private void breakForceWrench() {
        try {
            Class<?> api = Class.forName("bluedart.api.DartAPI");
            Field blacklist = api.getField("tileBlacklist");
            ArrayList list = (ArrayList)blacklist.get(null);
            RotaryCraft.logger.log((Object)"Breaking force wrench on RotaryCraft machines!");
            for (int i = 0; i < MachineRegistry.machineList.length; ++i) {
                Class machine = ((MachineRegistry)((Object)MachineRegistry.machineList.get(i))).getTEClass();
                list.add(machine);
                RotaryCraft.logger.log((Object)("Force wrench no longer works on " + ((MachineRegistry)((Object)MachineRegistry.machineList.get(i))).getName() + "!"));
            }
            blacklist.set(null, list);
        }
        catch (ClassNotFoundException e) {
            RotaryCraft.logger.logError((Object)"DartAPI class not found!");
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            RotaryCraft.logger.logError((Object)"DartAPI TileBlackList field not found!");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            RotaryCraft.logger.logError((Object)("DartAPI class threw security exception! " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            RotaryCraft.logger.logError((Object)"Could not add argument to DartAPI list!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            RotaryCraft.logger.logError((Object)"DartAPI class fields not accessible!");
            e.printStackTrace();
        }
    }

    private void intercraftDart() {
        GameRegistry.addShapelessRecipe((ItemStack)DartOreHandler.getInstance().getForceGem(), (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.FORCE)});
        RotaryCraft.logger.log((Object)"RotaryCraft force gems can now be crafted into DartCraft force gems!");
    }

    private void registerDart() {
        DartOreHandler.getInstance().forceOreRegistration();
    }

    private void intercraftForcicium() {
        try {
            Class mf = ModList.MFFS.getItemClass();
            Field item = mf.getField("MFFSitemForcicium");
            ItemStack forc = new ItemStack((Item)item.get(null));
            GameRegistry.addShapelessRecipe((ItemStack)forc, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.MONAZIT)});
            RotaryCraft.logger.log((Object)"RotaryCraft monazit can now be crafted into MFFS forcicium!");
        }
        catch (NoSuchFieldException e) {
            RotaryCraft.logger.logError((Object)"MFFS item field not found!");
        }
        catch (SecurityException e) {
            RotaryCraft.logger.logError((Object)("Cannot read MFFS items (Security Exception)! Monazit not convertible!" + e.getMessage()));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            RotaryCraft.logger.logError((Object)"Illegal argument for reading MFFS items!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            RotaryCraft.logger.logError((Object)"Illegal access exception for reading MFFS items!");
            e.printStackTrace();
        }
    }

    private void intercraftQuartz() {
        ItemStack quartz = AppEngHandler.getInstance().getCertusQuartz();
        if (quartz == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.APPENG, "Null ItemStack for Certus Quartz");
        }
        GameRegistry.addShapelessRecipe((ItemStack)quartz, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.CERTUSQUARTZ)});
        RotaryCraft.logger.log((Object)"RotaryCraft certus quartz can now be crafted into AppliedEnergistics certus quartz!");
    }

    private void intercraftApatite() {
        Item id = ForestryHandler.ItemEntry.APATITE.getItem();
        if (id == null) {
            throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.FORESTRY, "Null Item for Apatite");
        }
        ItemStack apatite = new ItemStack(id, 1, 0);
        GameRegistry.addShapelessRecipe((ItemStack)apatite, (Object[])new Object[]{ItemStacks.getModOreIngot(ModOreList.APATITE)});
        RotaryCraft.logger.log((Object)"RotaryCraft apatite can now be crafted into Forestry apatite!");
    }

    private void intercraftThaumcraft() {
        RotaryCraft.logger.log((Object)"Adding ore item conversion recipes!");
        for (int i = 0; i < ModOreList.oreList.length; ++i) {
            ModOreList o = ModOreList.oreList[i];
            if (!o.isThaumcraft()) continue;
            ItemStack is = ThaumOreHandler.getInstance().getItem(o);
            GameRegistry.addShapelessRecipe((ItemStack)is, (Object[])new Object[]{ItemStacks.getModOreIngot(o)});
            if (is == null) {
                throw new ModReflectionException((DragonAPIMod)RotaryCraft.instance, ModList.THAUMCRAFT, "Null ItemStack for Thaumcraft's " + o);
            }
            RotaryCraft.logger.log((Object)(o.displayName + " can now be crafted with RotaryCraft equivalents!"));
        }
    }

    private void registerThaumcraft() {
        ThaumOreHandler.getInstance().forceOreRegistration();
    }
}

