/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Conversion;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModInteract.Power.ReikaPneumaticHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.RCToModConverter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;

public class TileEntityAirCompressor
extends TileEntityPowerReceiver
implements PressureTE,
RCToModConverter {
    private int pressure;
    private boolean isOut;
    public static final int MAXPRESSURE = 1000;
    private ForgeDirection facingDir;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.omega <= 1 || !this.hasOutputTile()) {
            if (this.phi > 0.0f) {
                double speed = 0.0125;
                this.phi = this.isOut ? (float)((double)this.phi + speed) : (float)((double)this.phi - speed);
                if (this.phi <= 0.0f) {
                    this.isOut = true;
                }
                if ((double)this.phi >= 0.5) {
                    this.isOut = false;
                }
            }
            return;
        }
        double speed = ReikaMathLibrary.logbase((long)this.omega, (int)2) * 0.025 / 6.0;
        if (speed > 0.125) {
            speed = 0.125;
        }
        if (this.isOut) {
            this.phi = (float)((double)this.phi + speed);
            if ((double)this.phi <= 0.095) {
                this.playSound(world, x, y, z);
            }
        } else {
            this.phi = (float)((double)this.phi - speed);
        }
        if (this.phi <= 0.0f) {
            this.isOut = true;
            this.phi = 0.0f;
        }
        if ((double)this.phi >= 0.5) {
            this.isOut = false;
        }
    }

    private void playSound(World world, int x, int y, int z) {
        int p = (int)(ReikaMathLibrary.logbase((long)this.omega, (int)2) / 8.0);
        float v = 0.5f * this.getSoundVolume(world, x, y, z);
        SoundRegistry.AIRCOMP.playSoundAtBlock(world, x, y, z, v, p);
    }

    private float getSoundVolume(World world, int x, int y, int z) {
        ForgeDirection dir = this.facingDir;
        if (dir == null) {
            return 1.0f;
        }
        ForgeDirection dir2 = dir.getOpposite();
        for (int i = 0; i < 6; ++i) {
            int dz;
            int dy;
            int dx;
            Block id;
            ForgeDirection side = this.dirs[i];
            if (side == dir || side == dir2 || (id = world.func_147439_a(dx = x + side.offsetX, dy = y + side.offsetY, dz = z + side.offsetZ)) == Blocks.field_150325_L) continue;
            return 1.0f;
        }
        return 0.2625f;
    }

    private boolean hasOutputTile() {
        TileEntity te = this.getAdjacentTileEntity(this.write);
        return ModList.PNEUMATICRAFT.isLoaded() && te instanceof IPneumaticMachine;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.COMPRESSOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 15 * this.pressure / 1000;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntity tile;
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power > 0L && ModList.PNEUMATICRAFT.isLoaded() && (tile = this.getAdjacentTileEntity(this.write)) instanceof IPneumaticMachine) {
            IPneumaticMachine rc = (IPneumaticMachine)tile;
            IAirHandler a = rc.getAirHandler();
            if (a == null) {
                return;
            }
            int air = this.getGenAir();
            a.addAir(air, this.write.getOpposite());
        }
        if (this.tickcount < 20) {
            return;
        }
        this.tickcount = 0;
        this.updatePressure(world, x, y, z, meta);
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.facingDir = ForgeDirection.DOWN;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.UP;
                break;
            }
            case 2: {
                this.facingDir = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 4: {
                this.facingDir = ForgeDirection.SOUTH;
                break;
            }
            case 5: {
                this.facingDir = ForgeDirection.EAST;
            }
        }
        this.read = this.facingDir;
        this.write = this.read.getOpposite();
    }

    public boolean isPipeConnected(ForgeDirection with) {
        switch (this.func_145832_p()) {
            case 4: {
                return with == ForgeDirection.NORTH;
            }
            case 5: {
                return with == ForgeDirection.WEST;
            }
            case 2: {
                return with == ForgeDirection.SOUTH;
            }
            case 3: {
                return with == ForgeDirection.EAST;
            }
            case 0: {
                return with == ForgeDirection.UP;
            }
            case 1: {
                return with == ForgeDirection.DOWN;
            }
        }
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pressure = NBT.func_74762_e("pressure");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("pressure", this.pressure);
    }

    @Override
    public void updatePressure(World world, int x, int y, int z, int meta) {
        int Pamb = 101;
        if (this.pressure > Pamb) {
            this.addPressure((Pamb - this.pressure) / 50);
        }
        this.addPressure((int)Math.sqrt(this.power) / 64);
        if (this.pressure > 1000) {
            this.overpressure(world, x, y, z);
        }
    }

    @Override
    public void addPressure(int press) {
        this.pressure += press;
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void overpressure(World world, int x, int y, int z) {
        this.pressure = 1000;
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f + rand.nextFloat() * 2.0f, ConfigRegistry.BLOCKDAMAGE.getState());
        for (int i = 0; i < 6; ++i) {
            world.func_72876_a(null, (double)x + 0.5 - 1.0 + rand.nextDouble() * 2.0, (double)y + 0.5 - 1.0 + rand.nextDouble() * 2.0, (double)z + 0.5 - 1.0 + rand.nextDouble() * 2.0, 3.0f, ConfigRegistry.BLOCKDAMAGE.getState());
        }
    }

    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.isPipeConnected(side);
    }

    public int getGenAir() {
        return (int)((double)(this.power / (long)ReikaPneumaticHelper.getWattsPerAir()) * ConfigRegistry.getConverterEfficiency());
    }

    @Override
    public int getMaxPressure() {
        return 1000;
    }

    @Override
    public int getGeneratedUnitsPerTick() {
        return this.getGenAir();
    }

    @Override
    public String getUnitDisplay() {
        return "mL";
    }
}

