/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.AppEngHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.GregOreHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesGrinder
extends RecipeHandler
implements RecipeInterface.GrinderManager {
    private static final RecipesGrinder GrinderBase = new RecipesGrinder();
    public static final int ore_rate = 3;
    private final ItemHashMap<GrinderRecipe> recipes = new ItemHashMap();

    public static final RecipesGrinder getRecipes() {
        return GrinderBase;
    }

    private RecipesGrinder() {
        super(MachineRegistry.GRINDER);
        RecipeInterface.grinder = this;
        this.addRecipe(Blocks.field_150348_b, new ItemStack(Blocks.field_150347_e), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150347_e, new ItemStack(Blocks.field_150351_n), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150351_n, new ItemStack((Block)Blocks.field_150354_m), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150359_w, new ItemStack((Block)Blocks.field_150354_m), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150322_A, new ItemStack((Block)Blocks.field_150354_m), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150372_bz, new ItemStack((Block)Blocks.field_150354_m, 6, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO, 4, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150417_aV, new ItemStack(Blocks.field_150347_e), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150460_al, new ItemStack(Blocks.field_150347_e, 8, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150336_V, new ItemStack(Items.field_151119_aD, 4, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150435_aG, new ItemStack(Items.field_151119_aD, 4, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150389_bf, new ItemStack(Items.field_151119_aD, 6, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Items.field_151118_aC, new ItemStack(Items.field_151119_aD), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150446_ar, new ItemStack(Blocks.field_150351_n, 2, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150390_bg, new ItemStack(Blocks.field_150347_e, 2, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150424_aL, ItemStacks.netherrackdust, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(Blocks.field_150425_aM, ItemStacks.tar, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(Items.field_151015_O, ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.flour, (int)3), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(ItemStacks.bedingot.func_77946_l(), ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.bedrockdust, (int)4), RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(Items.field_151120_aE, new ItemStack(Items.field_151102_aT, 3), RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(Items.field_151103_aS, new ItemStack(Items.field_151100_aR, 9, 15), RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(Items.field_151072_bj, new ItemStack(Items.field_151065_br, 6, 0), RecipeHandler.RecipeLevel.PROTECTED);
        for (int i = 0; i < ReikaTreeHelper.treeList.length; ++i) {
            ReikaTreeHelper tree = ReikaTreeHelper.treeList[i];
            this.addRecipe(tree.getLog(), this.getSizedSawdust(16), RecipeHandler.RecipeLevel.PERIPHERAL);
            this.addRecipe(new ItemStack(Blocks.field_150344_f, 1, tree.ordinal()), this.getSizedSawdust(4), RecipeHandler.RecipeLevel.PERIPHERAL);
        }
        this.addRecipe(Blocks.field_150323_B, this.getSizedSawdust(32), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150421_aI, this.getSizedSawdust(32), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150422_aJ, this.getSizedSawdust(4), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150476_ad, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150487_bG, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150485_bF, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150481_bH, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150400_ck, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150401_cl, this.getSizedSawdust(6), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe((Block)Blocks.field_150486_ae, this.getSizedSawdust(32), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150462_ai, this.getSizedSawdust(16), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150468_ap, this.getSizedSawdust(4), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150452_aw, this.getSizedSawdust(8), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150456_au, new ItemStack(Blocks.field_150347_e, 2, 0), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Items.field_151054_z, this.getSizedSawdust(ModList.GREGTECH.isLoaded() ? 4 : 12), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Items.field_151135_aq, this.getSizedSawdust(24), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Items.field_151155_ap, this.getSizedSawdust(24), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Items.field_151055_y, this.getSizedSawdust(2), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150415_aT, this.getSizedSawdust(24), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(Blocks.field_150396_be, this.getSizedSawdust(16), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addFlowerDyes();
        this.addRecipe(Items.field_151044_h, ItemStacks.coaldust, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.canolaSeeds, ItemStacks.canolaHusks, RecipeHandler.RecipeLevel.CORE);
        this.addOreDictRecipe("plankWood", this.getSizedSawdust(4), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addOreDictRecipe("logWood", this.getSizedSawdust(16), RecipeHandler.RecipeLevel.PERIPHERAL);
    }

    private void addFlowerDyes() {
        Object[][] recipes = new Object[][]{{Blocks.field_150327_N, 0, ReikaItemHelper.yellowDye}, {Blocks.field_150328_O, 0, ReikaItemHelper.redDye}, {Blocks.field_150328_O, 1, ReikaItemHelper.lblueDye}, {Blocks.field_150328_O, 2, ReikaItemHelper.magentaDye}, {Blocks.field_150328_O, 3, ReikaItemHelper.lgrayDye}, {Blocks.field_150328_O, 4, ReikaItemHelper.redDye}, {Blocks.field_150328_O, 5, ReikaItemHelper.orangeDye}, {Blocks.field_150328_O, 6, ReikaItemHelper.lgrayDye}, {Blocks.field_150328_O, 7, ReikaItemHelper.pinkDye}, {Blocks.field_150328_O, 8, ReikaItemHelper.lgrayDye}, {Blocks.field_150398_cm, 1, ReikaItemHelper.magentaDye}, {Blocks.field_150398_cm, 4, ReikaItemHelper.redDye}, {Blocks.field_150398_cm, 5, ReikaItemHelper.pinkDye}};
        for (int i = 0; i < recipes.length; ++i) {
            Object[] r = recipes[i];
            ItemStack is = new ItemStack((Block)r[0], 1, ((Integer)r[1]).intValue());
            ItemStack out = (ItemStack)r[2];
            this.addRecipe(is, ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)6));
        }
    }

    private ItemStack getSizedSawdust(int size) {
        return ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.sawdust, (int)size);
    }

    public boolean isGrindable(ItemStack item) {
        return this.getGrindingResult(item) != null;
    }

    public boolean isProduct(ItemStack item) {
        for (GrinderRecipe gr : this.recipes.values()) {
            if (!gr.makesItem(item)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getSources(ItemStack out) {
        ArrayList<ItemStack> in = new ArrayList<ItemStack>();
        for (ItemStack input : this.recipes.keySet()) {
            GrinderRecipe gr = (GrinderRecipe)this.recipes.get(input);
            if (!gr.makesItem(out)) continue;
            in.add(input.func_77946_l());
        }
        return in;
    }

    public void addDualOreDictRecipe(String in, String out, int numout, RecipeHandler.RecipeLevel rl) {
        ItemStack isout;
        ItemStack itemStack = isout = ReikaItemHelper.oreItemExists((String)out) ? (ItemStack)OreDictionary.getOres((String)out).get(0) : null;
        if (isout != null) {
            this.addOreDictRecipe(in, ReikaItemHelper.getSizedItemStack((ItemStack)isout, (int)numout), rl);
        }
    }

    public void addOreDictRecipe(String in, ItemStack out, RecipeHandler.RecipeLevel rl) {
        ArrayList li = OreDictionary.getOres((String)in);
        for (ItemStack sin : li) {
            if (this.recipes.containsKey(sin)) continue;
            this.addRecipe(sin, out, rl);
        }
    }

    @Override
    public void addAPIRecipe(ItemStack in, ItemStack out) {
        this.addRecipe(in, out, RecipeHandler.RecipeLevel.API);
    }

    private void addRecipe(Block in, ItemStack out, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), out, rl);
    }

    private void addRecipe(Item in, ItemStack out, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), out, rl);
    }

    public void addRecipe(ItemStack in, ItemStack out) {
        this.addRecipe(in, out, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(ItemStack in, ItemStack out, RecipeHandler.RecipeLevel rl) {
        GrinderRecipe rec = new GrinderRecipe(in, out);
        this.recipes.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    public void addCustomRecipe(ItemStack in, ItemStack out) {
        this.addRecipe(in, out, RecipeHandler.RecipeLevel.CUSTOM);
    }

    public ItemStack getGrindingResult(ItemStack item) {
        GrinderRecipe ret = item != null ? (GrinderRecipe)this.recipes.get(item) : null;
        return ret != null ? ret.output.func_77946_l() : null;
    }

    @Override
    public void addPostLoadRecipes() {
        ItemStack endDust;
        ArrayList obsididust;
        ItemStack dust;
        this.addOreRecipes();
        if (ModList.APPENG.isLoaded()) {
            ItemStack cry = AppEngHandler.getInstance().getCertusQuartz();
            dust = AppEngHandler.getInstance().getCertusQuartzDust();
            if (cry != null && dust != null) {
                this.addRecipe(cry, dust, RecipeHandler.RecipeLevel.MODINTERACT);
            } else {
                RotaryCraft.logger.logError((Object)("Could not add certus quartz grinding; null itemstack " + cry + ", " + dust));
            }
            ItemStack fluix = AppEngHandler.getInstance().getFluixCrystal();
            ItemStack fluixdust = AppEngHandler.getInstance().getFluixDust();
            if (fluix != null && fluixdust != null) {
                this.addRecipe(fluix, fluixdust, RecipeHandler.RecipeLevel.MODINTERACT);
            } else {
                RotaryCraft.logger.logError((Object)("Could not add certus quartz grinding; null itemstack " + fluix + ", " + fluixdust));
            }
        }
        if (!(obsididust = OreDictionary.getOres((String)"dustObsidian")).isEmpty()) {
            this.addRecipe(Blocks.field_150343_Z, ReikaItemHelper.getSizedItemStack((ItemStack)((ItemStack)obsididust.get(0)), (int)6), RecipeHandler.RecipeLevel.MODINTERACT);
        }
        this.addDualOreDictRecipe("rodBlizz", "dustBlizz", 6, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addDualOreDictRecipe("rodBlitz", "dustBlitz", 6, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addDualOreDictRecipe("rodBasalz", "dustBasalz", 6, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addOreDictRecipe("netherrack", ItemStacks.netherrackdust, RecipeHandler.RecipeLevel.CORE);
        this.addOreDictRecipe("soulsand", ItemStacks.tar, RecipeHandler.RecipeLevel.CORE);
        if (ModList.BOTANIA.isLoaded()) {
            Item petal = GameRegistry.findItem((String)ModList.BOTANIA.modLabel, (String)"petal");
            Item dye = GameRegistry.findItem((String)ModList.BOTANIA.modLabel, (String)"dye");
            Block flower = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"flower");
            Block tallflower1 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower1");
            Block tallflower2 = GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"doubleFlower2");
            for (int i = 0; i < 16; ++i) {
                Block tall = i >= 8 ? tallflower2 : tallflower1;
                int tallm = i % 8;
                this.addRecipe(new ItemStack(flower, 1, i), new ItemStack(petal, 6, i), RecipeHandler.RecipeLevel.MODINTERACT);
                this.addRecipe(new ItemStack(tall, 1, tallm), new ItemStack(petal, 12, i), RecipeHandler.RecipeLevel.MODINTERACT);
                this.addRecipe(new ItemStack(petal, 1, i), new ItemStack(dye, 3, i), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        if ((dust = ReikaItemHelper.lookupItem((String)"exnihilo:dust")) != null) {
            this.addRecipe((Block)Blocks.field_150354_m, dust, RecipeHandler.RecipeLevel.MODINTERACT);
        }
        if ((endDust = ReikaItemHelper.lookupItem((String)"exnihilo:exnihilo.gravel_ender")) != null) {
            this.addRecipe(Blocks.field_150377_bs, endDust, RecipeHandler.RecipeLevel.MODINTERACT);
        }
        if (ModList.HARVESTCRAFT.isLoaded()) {
            ItemStack corn = ReikaItemHelper.lookupItem((String)"harvestcraft:cornItem");
            ItemStack fla = ReikaItemHelper.lookupItem((String)"harvestcraft:cornflakesItem");
            if (corn != null && fla != null) {
                this.addRecipe(corn, ReikaItemHelper.getSizedItemStack((ItemStack)fla, (int)3), RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
        this.addOreDictRecipe("cropCinderpearl", new ItemStack(Items.field_151065_br, 3, 0), RecipeHandler.RecipeLevel.MODINTERACT);
        this.addOreDictRecipe("cropShimmerleaf", ReikaItemHelper.getSizedItemStack((ItemStack)ExtractorModOres.getSmeltedIngot(ModOreList.CINNABAR), (int)3), RecipeHandler.RecipeLevel.MODINTERACT);
    }

    private void addOreRecipes() {
        Collection li;
        ReikaOreHelper ore;
        int i;
        for (i = 0; i < ReikaOreHelper.oreList.length; ++i) {
            ore = ReikaOreHelper.oreList[i];
            li = ore.getAllOreBlocks();
            for (ItemStack is : li) {
                if (this.recipes.containsKey(is)) {
                    ReikaOreHelper mod = ReikaOreHelper.oreList[((GrinderRecipe)this.recipes.get(is)).output.func_77960_j()];
                    RotaryCraft.logger.log((Object)("Ore " + is.func_82833_r() + " is being skipped for grinder registration as " + ore + " as it is already registered to " + mod));
                    continue;
                }
                ItemStack flake = ItemRegistry.EXTRACTS.getCraftedMetadataProduct(3, 24 + ore.ordinal());
                this.addRecipe(is, ReikaItemHelper.getSizedItemStack((ItemStack)flake, (int)3), RecipeHandler.RecipeLevel.CORE);
                int n = 3;
                if (ore.getRarity() == OreType.OreRarity.RARE) {
                    n *= 3;
                }
                RotaryCraft.logger.log((Object)("Adding " + n + "x grinder recipe for " + ore + " ore " + is));
            }
        }
        for (i = 0; i < ModOreList.oreList.length; ++i) {
            ore = ModOreList.oreList[i];
            li = ore.getAllOreBlocks();
            int n = 3;
            if (ore.isNetherOres()) {
                n *= 2;
            } else if (ore.getRarity() == OreType.OreRarity.RARE) {
                n *= 3;
            }
            for (ItemStack is : li) {
                if (this.recipes.containsKey(is)) {
                    OreType mod = ExtractorModOres.getOreFromExtract(((GrinderRecipe)this.recipes.get(is)).output);
                    RotaryCraft.logger.log((Object)("Ore " + is.func_82833_r() + " is being skipped for grinder registration as " + ore + " as it is already registered to " + mod));
                    continue;
                }
                ItemStack flake = ExtractorModOres.getFlakeProduct((ModOreList)ore);
                this.addRecipe(is, ReikaItemHelper.getSizedItemStack((ItemStack)flake, (int)n), RecipeHandler.RecipeLevel.CORE);
                RotaryCraft.logger.log((Object)("Adding " + n + "x grinder recipe for " + ore + " ore " + is));
            }
        }
        if (ModList.GREGTECH.isLoaded()) {
            this.loadGTOres();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.GREGTECH)
    private void loadGTOres() {
        for (GregOreHandler.CounterpartOres ore : GregOreHandler.CounterpartOres.oreList) {
            for (ItemStack is : ore.getAllOreBlocks()) {
                int n = Math.max(1, (int)Math.round(3.0 * ore.yieldFraction));
                OreType base = ore.counterpart;
                ItemStack flake = base instanceof ReikaOreHelper ? ItemRegistry.EXTRACTS.getCraftedMetadataProduct(n, 24 + base.ordinal()) : ExtractorModOres.getFlakeProduct((ModOreList)base);
                flake.field_77994_a = n;
                this.addRecipe(is, ReikaItemHelper.getSizedItemStack((ItemStack)flake, (int)n), RecipeHandler.RecipeLevel.CORE);
                RotaryCraft.logger.log((Object)("Adding " + n + "x grinder recipe for GT ore " + ore));
            }
        }
    }

    public Collection<ItemStack> getAllGrindables() {
        return Collections.unmodifiableCollection(this.recipes.keySet());
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.removeValue((Object)((GrinderRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        String ore;
        ItemStack out = crl.parseItemString(lb.getString("output"), lb.getChild("output_nbt"), false);
        this.verifyOutputItem(out);
        String string = ore = lb.containsKey("ore_input") ? lb.getString("ore_input") : null;
        if (ore != null && !ore.isEmpty() && !ore.startsWith("[NULL")) {
            ArrayList c = OreDictionary.getOres((String)ore);
            if (c.isEmpty()) {
                throw new IllegalArgumentException("Ore tag '" + ore + "' does not map to any existing OreDict tag!");
            }
            for (ItemStack in : c) {
                this.addCustomRecipe(in, out);
            }
            return true;
        }
        ItemStack in = crl.parseItemString(lb.getString("input"), lb.getChild("input_nbt"), false);
        this.addCustomRecipe(in, out);
        return true;
    }

    private static class GrinderRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack input;
        private final ItemStack output;

        private GrinderRecipe(ItemStack in, ItemStack out1) {
            this.input = in;
            this.output = out1;
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public boolean makesItem(ItemStack is) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.output);
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.input) + ">" + RecipeHandler.fullID(this.output);
        }

        @Override
        public String getAllInfo() {
            return "Grinding " + RecipeHandler.fullID(this.input) + " into " + RecipeHandler.fullID(this.output);
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object[])new ItemStack[]{this.input, this.output});
        }
    }
}

