/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.util;

public class TimeSandParser {
    public static String getStringForRenderingFromTimeSand(int timeSand) {
        TimeSandMode mode;
        if (timeSand >= 31104000) {
            mode = TimeSandMode.YEAR;
        } else if (timeSand >= 2592000) {
            mode = TimeSandMode.MONTH;
        } else if (timeSand >= 86400) {
            mode = TimeSandMode.DAY;
        } else if (timeSand >= 3600) {
            mode = TimeSandMode.HOUR;
        } else if (timeSand >= 60) {
            mode = TimeSandMode.MINUTE;
        } else if (timeSand > 0) {
            mode = TimeSandMode.SECOND;
        } else {
            return "No Time";
        }
        double timeSandD = timeSand;
        switch (mode) {
            case YEAR: {
                int numberOfYears = (int)(timeSandD / 3.1104E7);
                int numberOfMonths = (int)(timeSandD % 3.1104E7 / 2592000.0);
                return numberOfYears + "Yrs " + numberOfMonths + "Months";
            }
            case MONTH: {
                int numberOfMonths = (int)(timeSandD / 2592000.0);
                int numberOfDays = (int)(timeSandD % 2592000.0 / 86400.0);
                return numberOfMonths + "Months " + numberOfDays + "Days";
            }
            case DAY: {
                int numberOfDays = (int)(timeSandD / 86400.0);
                int numberOfHours = (int)(timeSandD % 86400.0 / 3600.0);
                return numberOfDays + "Days " + numberOfHours + "Hrs";
            }
            case HOUR: {
                int numberOfHours = (int)(timeSandD / 3600.0);
                int numberOfMinutes = (int)(timeSandD % 3600.0 / 60.0);
                return numberOfHours + "Hrs " + numberOfMinutes + "Mins";
            }
            case MINUTE: {
                int numberOfMinutes = (int)(timeSandD / 100.0);
                int numberOfSeconds = (int)(timeSandD % 100.0);
                return numberOfMinutes + "Mins " + numberOfSeconds + "Secs";
            }
            case SECOND: {
                return timeSand + " Seconds";
            }
        }
        return "Natural Time";
    }

    public static enum TimeSandMode {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

