/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.registry;

import java.util.ArrayList;
import java.util.Random;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.phaseevent.PhaseEventAbstract;
import lumaceon.mods.clockworkphase.util.Logger;

public class PhaseEventRegistry {
    private static ArrayList[] PHASE_EVENTS = new ArrayList[]{new ArrayList(5), new ArrayList(5), new ArrayList(5), new ArrayList(5), new ArrayList(5), new ArrayList(5), new ArrayList(5), new ArrayList(5)};

    public static void registerPhaseEvent(PhaseEventAbstract event, Phases phase) {
        event.setupID(PHASE_EVENTS[phase.ordinal()].size());
        PHASE_EVENTS[phase.ordinal()].add(event);
    }

    public static PhaseEventAbstract getRandomEventForPhase(Phases phase, Random random) {
        ArrayList events = PHASE_EVENTS[phase.ordinal()];
        if (!events.isEmpty()) {
            return (PhaseEventAbstract)events.get(random.nextInt(events.size()));
        }
        return null;
    }

    public static PhaseEventAbstract[] getAllPossiblePhaseEvents(Phases phase) {
        return (PhaseEventAbstract[])PHASE_EVENTS[phase.ordinal()].toArray();
    }

    public static PhaseEventAbstract getSpecificPhaseEvent(Phases phase, int id) {
        ArrayList events = PHASE_EVENTS[phase.ordinal()];
        if (id <= events.size() && id >= 0) {
            return (PhaseEventAbstract)events.get(id);
        }
        Logger.warn("[Tried to load a nonexistent phase event.]");
        Logger.warn("ID: " + id);
        Logger.warn("Phase: " + phase.toString());
        Logger.warn("Amount of available events for " + phase.toString() + " phase: " + events.size());
        return null;
    }
}

