/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import lumaceon.mods.clockworkphase.client.ClientTickHandler;
import lumaceon.mods.clockworkphase.client.handler.KeyHandler;
import lumaceon.mods.clockworkphase.client.handler.RenderHandler;
import lumaceon.mods.clockworkphase.client.handler.TextureStitchHandler;
import lumaceon.mods.clockworkphase.client.particle.ParticleGenerator;
import lumaceon.mods.clockworkphase.client.render.model.ModelChronoArmorBoots;
import lumaceon.mods.clockworkphase.client.render.model.ModelChronoArmorChestpiece;
import lumaceon.mods.clockworkphase.client.render.model.ModelChronoArmorHeadpiece;
import lumaceon.mods.clockworkphase.client.render.model.ModelChronoArmorLeggings;
import lumaceon.mods.clockworkphase.client.settings.Keybindings;
import lumaceon.mods.clockworkphase.item.construct.pocketwatch.module.ItemModule;
import lumaceon.mods.clockworkphase.proxy.CommonProxy;
import lumaceon.mods.clockworkphase.util.InventorySearchHelper;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.OverlayRenderData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static ParticleGenerator particleGenerator;
    public static ModelChronoArmorHeadpiece chronoArmorHeadpiece;
    public static ModelChronoArmorChestpiece chronoArmorChestpiece;
    public static ModelChronoArmorLeggings chronoArmorLeggings;
    public static ModelChronoArmorBoots chronoArmorBoots;
    public static ArrayList<OverlayRenderData> overlayRenderers;

    public static ModelBiped getChronoArmorModel(int id) {
        switch (id) {
            case 0: {
                return chronoArmorHeadpiece;
            }
            case 1: {
                return chronoArmorChestpiece;
            }
            case 2: {
                return chronoArmorLeggings;
            }
        }
        return chronoArmorBoots;
    }

    @Override
    public void setRenderingForPlayer(EntityPlayer player) {
        overlayRenderers.clear();
        if (player != null && player.field_71071_by != null) {
            ItemStack[] watches = InventorySearchHelper.getPocketWatches((IInventory)player.field_71071_by);
            for (int n = 0; watches != null && n < watches.length; ++n) {
                if (watches[n] == null) continue;
                ItemStack[] items = NBTHelper.getInventoryFromNBTTag(watches[n], "pw_modules");
                for (int i = 0; items != null && i < items.length; ++i) {
                    if (items[i] == null || !NBTHelper.getBoolean(items[i], "cp_active")) continue;
                    boolean dupe = false;
                    for (int q = 0; q < overlayRenderers.size() && !dupe; ++q) {
                        if (!ClientProxy.overlayRenderers.get((int)q).item.func_77973_b().equals(items[i].func_77973_b())) continue;
                        dupe = true;
                    }
                    if (dupe) continue;
                    overlayRenderers.add(new OverlayRenderData(items[i], NBTHelper.getInt(items[i], "module_power") / ((ItemModule)items[i].func_77973_b()).getPowerDivisor()));
                }
            }
        }
    }

    public static void setRenderNumberForItemStack(ItemStack item, int number) {
        for (int n = 0; n < overlayRenderers.size(); ++n) {
            OverlayRenderData renderer = overlayRenderers.get(n);
            if (renderer == null || !renderer.item.func_77973_b().equals(item.func_77973_b())) continue;
            renderer.setNumberToRender(number);
        }
    }

    @Override
    public void registerKeybindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.multitool);
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.temporal);
    }

    @Override
    public void initializeParticleGenerator() {
        particleGenerator = new ParticleGenerator(Minecraft.func_71410_x());
    }

    @Override
    public void initializeSideOnlyHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new TextureStitchHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderHandler());
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
    }

    @Override
    public void registerModels() {
    }

    @Override
    public World getStaticWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public MovingObjectPosition getObjectLookedAt() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    static {
        chronoArmorHeadpiece = new ModelChronoArmorHeadpiece(1.0f);
        chronoArmorChestpiece = new ModelChronoArmorChestpiece(1.0f);
        chronoArmorLeggings = new ModelChronoArmorLeggings(0.5f);
        chronoArmorBoots = new ModelChronoArmorBoots(1.0f);
        overlayRenderers = new ArrayList(20);
    }
}

