/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.hourglass;

import lumaceon.mods.clockworkphase.item.construct.hourglass.ItemHourglass;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.PhaseHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemHourglassLunar
extends ItemHourglass {
    public void func_77663_a(ItemStack is, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (entity instanceof EntityPlayer && NBTHelper.getBoolean(is, "cp_active")) {
            int newTension;
            EntityPlayer player = (EntityPlayer)entity;
            int tension = NBTHelper.getInt(is, "tension_energy");
            int quality = NBTHelper.getInt(is, "cp_quality");
            if (quality <= 0) {
                return;
            }
            int speed = NBTHelper.getInt(is, "cp_speed");
            int memory = NBTHelper.getInt(is, "cp_memory");
            float efficiency = (float)speed / (float)quality;
            int tensionCost = (int)Math.round((double)MechanicTweaker.LUNAR_HOURGLASS_TENSION_COST * Math.pow(efficiency, 2.0));
            if (PhaseHelper.getPhaseForWorld(world).equals((Object)Phases.LUNAR)) {
                tensionCost = (int)((double)tensionCost * 0.1);
            }
            if (world.func_72820_D() % 24000L >= 14000L && world.func_72820_D() % 24000L <= 22000L) {
                tensionCost = (int)((double)tensionCost * 0.5);
            }
            if ((newTension = tension - tensionCost) <= 0) {
                this.removeTension(is, tension);
                NBTHelper.setBoolean(is, "cp_active", false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                return;
            }
            if (efficiency > 10.0f) {
                NBTHelper.setBoolean(is, "cp_active", false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                player.func_146105_b((IChatComponent)new ChatComponentText("Your clockwork's quality can't handle it's speed."));
                return;
            }
            if (speed < 50) {
                NBTHelper.setBoolean(is, "cp_active", false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                player.func_146105_b((IChatComponent)new ChatComponentText("Your clockwork's speed is too slow to be of any use."));
                return;
            }
            if (speed > 500) {
                speed = 500;
            }
            double x = NBTHelper.getDouble(is, "cp_motion_x") * (0.99 + (double)(speed / 500 / 100));
            double y = NBTHelper.getDouble(is, "cp_motion_y") * (0.99 + (double)(speed / 500 / 100));
            double z = NBTHelper.getDouble(is, "cp_motion_z") * (0.99 + (double)(speed / 500 / 100));
            if (player.field_70159_w != x) {
                NBTHelper.setDouble(is, "cp_motion_x", x);
            }
            if (player.field_70181_x != y) {
                NBTHelper.setDouble(is, "cp_motion_y", y);
            }
            if (player.field_70179_y != z) {
                NBTHelper.setDouble(is, "cp_motion_z", z);
            }
            player.field_70159_w = x;
            player.field_70181_x = y;
            player.field_70179_y = z;
            player.field_70143_R = 0.0f;
            this.removeTension(is, tensionCost);
        }
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int meta, float f1, float f2, float f3) {
        boolean isActive = NBTHelper.getBoolean(is, "cp_active");
        NBTHelper.setBoolean(is, "cp_active", !isActive);
        NBTHelper.setDouble(is, "cp_motion_x", player.field_70159_w);
        NBTHelper.setDouble(is, "cp_motion_y", player.field_70181_x);
        NBTHelper.setDouble(is, "cp_motion_z", player.field_70179_y);
        if (isActive && !player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        } else {
            player.field_71075_bZ.field_75101_c = true;
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        boolean isActive = NBTHelper.getBoolean(is, "cp_active");
        NBTHelper.setBoolean(is, "cp_active", !isActive);
        NBTHelper.setDouble(is, "cp_motion_x", player.field_70159_w);
        NBTHelper.setDouble(is, "cp_motion_y", player.field_70181_x);
        NBTHelper.setDouble(is, "cp_motion_z", player.field_70179_y);
        if (isActive && !player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        } else {
            player.field_71075_bZ.field_75101_c = true;
        }
        return is;
    }
}

