/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAdvancedBlockExtender
extends TileBlockExtender
implements IAdvancedTile {
    private boolean spreadItems = false;
    private byte[] insertDirection = new byte[]{1, 1, 1, 1, 1, 1, 1};
    private int bestSlot;
    private boolean shouldUpdateBestSlot = true;
    private int lastSide;
    private ItemStack lastStack;
    private byte maxStackSize = (byte)64;

    @Override
    public byte[] getInsertDirection() {
        return this.insertDirection;
    }

    @Override
    public void setInsertDirection(int from, int value) {
        int numDirs = ForgeDirection.VALID_DIRECTIONS.length;
        value = (value % numDirs + numDirs) % numDirs;
        this.insertDirection[from] = (byte)value;
        this.func_70296_d();
    }

    @Override
    public void setConnectedSide(int connectedSide) {
        ForgeDirection lastConnectedDirection = this.connectedDirection;
        super.setConnectedSide(connectedSide);
        if (this.connectedDirection != ForgeDirection.UNKNOWN && this.connectedDirection != lastConnectedDirection) {
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                this.insertDirection[i] = (byte)this.connectedDirection.getOpposite().ordinal();
            }
        }
    }

    @Override
    public boolean getSpreadItems() {
        return this.spreadItems;
    }

    @Override
    public void setSpreadItems(boolean spreadItems) {
        this.spreadItems = spreadItems;
        this.func_70296_d();
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int i2) {
        if (this.spreadItems) {
            if (this.shouldUpdateBestSlot || this.lastSide != i2 || !ItemStackHelper.areItemStacksEqual(itemStack, this.lastStack)) {
                this.updateBestSlot(i2, itemStack);
                this.shouldUpdateBestSlot = false;
            }
            if (i != this.bestSlot || !super.func_102007_a(this.bestSlot, itemStack, i2)) {
                return false;
            }
            this.shouldUpdateBestSlot = true;
            return true;
        }
        return super.func_102007_a(i, itemStack, i2);
    }

    private void updateBestSlot(int side, ItemStack itemStack) {
        int[] invAccessibleSlots;
        int bestSize = Integer.MAX_VALUE;
        for (int slot : invAccessibleSlots = this.func_94128_d(side)) {
            ItemStack stack = this.func_70301_a(slot);
            if (!super.func_102007_a(slot, itemStack, side)) continue;
            if (stack == null) {
                this.bestSlot = slot;
                break;
            }
            if (!ItemStackHelper.areItemStacksEqual(itemStack, stack) || stack.field_77994_a >= bestSize) continue;
            this.bestSlot = slot;
            bestSize = stack.field_77994_a;
        }
        this.lastSide = side;
        this.lastStack = itemStack;
    }

    @Override
    public int[] func_94128_d(int i) {
        if (this.getInventory() != null) {
            if (this.getInventory() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getInventory()).func_94128_d(this.getInputSide(ForgeDirection.getOrientation((int)i)).ordinal());
            }
            return this.accessibleSlots;
        }
        return new int[0];
    }

    @Override
    public byte getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public void setMaxStackSize(byte maxStackSize) {
        this.maxStackSize = maxStackSize;
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return Math.min(super.func_70297_j_(), this.maxStackSize);
        }
        return this.maxStackSize;
    }

    @Override
    public ForgeDirection getInputSide(ForgeDirection side) {
        return ForgeDirection.getOrientation((int)this.insertDirection[side.ordinal()]);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.spreadItems = compound.func_74767_n("spreadItems");
        this.insertDirection = compound.func_74770_j("insertDirection");
        this.maxStackSize = compound.func_74771_c("maxStackSize");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("spreadItems", this.spreadItems);
        compound.func_74773_a("insertDirection", this.insertDirection);
        compound.func_74774_a("maxStackSize", this.maxStackSize);
    }
}

