/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.network;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.IMultiFilterTile;
import com.dynious.refinedrelocation.client.gui.GuiAdvancedBlockExtender;
import com.dynious.refinedrelocation.client.gui.GuiAdvancedBuffer;
import com.dynious.refinedrelocation.client.gui.GuiBlockExtender;
import com.dynious.refinedrelocation.client.gui.GuiFiltered;
import com.dynious.refinedrelocation.client.gui.GuiFilteringHopper;
import com.dynious.refinedrelocation.client.gui.GuiPowerLimiter;
import com.dynious.refinedrelocation.client.gui.GuiSortingChest;
import com.dynious.refinedrelocation.client.gui.GuiSortingInputPane;
import com.dynious.refinedrelocation.container.ContainerAdvanced;
import com.dynious.refinedrelocation.container.ContainerAdvancedFiltered;
import com.dynious.refinedrelocation.container.ContainerBlockExtender;
import com.dynious.refinedrelocation.container.ContainerFiltered;
import com.dynious.refinedrelocation.container.ContainerFilteringHopper;
import com.dynious.refinedrelocation.container.ContainerPowerLimiter;
import com.dynious.refinedrelocation.container.ContainerSortingChest;
import com.dynious.refinedrelocation.container.ContainerSortingInputPane;
import com.dynious.refinedrelocation.tileentity.IAdvancedFilteredTile;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import com.dynious.refinedrelocation.tileentity.TileAdvancedBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileAdvancedBuffer;
import com.dynious.refinedrelocation.tileentity.TileAdvancedFilteredBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileFilteringHopper;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import com.dynious.refinedrelocation.tileentity.TileSortingChest;
import com.dynious.refinedrelocation.tileentity.TileSortingInputPane;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiHandler
implements IGuiHandler {
    public GuiHandler() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RefinedRelocation.instance, (IGuiHandler)this);
    }

    public Object getServerGuiElement(int guiId, EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            switch (guiId) {
                case 12: {
                    if (!(tile instanceof IFilterTileGUI)) break;
                    return new ContainerFiltered((IFilterTileGUI)tile);
                }
                case 10: {
                    if (tile instanceof TileBlockExtender) {
                        return new ContainerBlockExtender((TileBlockExtender)tile);
                    }
                }
                case 11: 
                case 21: {
                    if (!(tile instanceof IAdvancedTile)) break;
                    return new ContainerAdvanced((IAdvancedTile)tile);
                }
                case 13: {
                    if (!(tile instanceof IAdvancedFilteredTile)) break;
                    return new ContainerAdvancedFiltered((IAdvancedFilteredTile)tile);
                }
                case 30: {
                    if (!(tile instanceof TileSortingChest)) break;
                    return new ContainerSortingChest(entityPlayer, (TileSortingChest)tile);
                }
                case 31: {
                    if (!(tile instanceof TileFilteringHopper)) break;
                    return new ContainerFilteringHopper(entityPlayer.field_71071_by, (IMultiFilterTile)tile);
                }
                case 32: {
                    if (!(tile instanceof TileSortingInputPane)) break;
                    return new ContainerSortingInputPane(entityPlayer, (TileSortingInputPane)tile);
                }
                case 33: {
                    if (!(tile instanceof TilePowerLimiter)) break;
                    return new ContainerPowerLimiter((TilePowerLimiter)tile);
                }
            }
            if (guiId >= 40 && guiId < 40 + ForgeDirection.VALID_DIRECTIONS.length && tile instanceof IRelocator) {
                return ((IRelocator)tile).getContainer(guiId - 40, entityPlayer);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int guiId, EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            switch (guiId) {
                case 11: {
                    if (!(tile instanceof TileAdvancedBlockExtender)) break;
                    return new GuiAdvancedBlockExtender(entityPlayer.field_71071_by, (TileAdvancedBlockExtender)tile);
                }
                case 10: {
                    if (tile instanceof TileBlockExtender) {
                        return new GuiBlockExtender(entityPlayer.field_71071_by, (TileBlockExtender)tile);
                    }
                }
                case 12: {
                    if (!(tile instanceof IFilterTileGUI)) break;
                    return new GuiFiltered((IFilterTileGUI)tile, new ContainerFiltered((IFilterTileGUI)tile));
                }
                case 13: {
                    if (!(tile instanceof TileAdvancedFilteredBlockExtender)) break;
                    return new GuiFiltered((IMultiFilterTile)tile, new ContainerAdvancedFiltered((IAdvancedFilteredTile)tile));
                }
                case 21: {
                    if (!(tile instanceof TileAdvancedBuffer)) break;
                    return new GuiAdvancedBuffer(entityPlayer.field_71071_by, (TileAdvancedBuffer)tile);
                }
                case 30: {
                    if (!(tile instanceof TileSortingChest)) break;
                    return new GuiSortingChest(entityPlayer, (TileSortingChest)tile);
                }
                case 31: {
                    if (!(tile instanceof TileFilteringHopper)) break;
                    return new GuiFilteringHopper(entityPlayer.field_71071_by, (TileFilteringHopper)tile);
                }
                case 32: {
                    if (!(tile instanceof TileSortingInputPane)) break;
                    return new GuiSortingInputPane(entityPlayer, (TileSortingInputPane)tile);
                }
                case 33: {
                    if (!(tile instanceof TilePowerLimiter)) break;
                    return new GuiPowerLimiter((TilePowerLimiter)tile);
                }
            }
            if (guiId >= 40 && guiId < 40 + ForgeDirection.VALID_DIRECTIONS.length && tile instanceof IRelocator) {
                return ((IRelocator)tile).getGUI(guiId - 40, entityPlayer);
            }
        }
        return null;
    }
}

