/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.filter;

import com.dynious.refinedrelocation.api.filter.IChecklistFilter;
import com.dynious.refinedrelocation.api.gui.IGuiWidgetWrapped;
import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiFilterList;
import com.dynious.refinedrelocation.grid.MultiFilter;
import com.dynious.refinedrelocation.grid.filter.MultiFilterChildBase;
import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.IPlantable;

public class PresetFilter
extends MultiFilterChildBase
implements IChecklistFilter {
    public static final int PRESET_COUNT = 14;
    public static final String TYPE_NAME = "preset";
    private static TextureRegion iconTexture;
    private boolean[] presets = new boolean[14];

    @Override
    public boolean isInFilter(ItemStack itemStack) {
        String[] oreNames;
        for (String oreName : oreNames = MultiFilter.getOreNames(itemStack)) {
            if (this.presets[0] && (oreName.contains("ingot") || itemStack.func_77973_b() == Items.field_151042_j || itemStack.func_77973_b() == Items.field_151043_k)) {
                return true;
            }
            if (this.presets[1] && oreName.contains("ore")) {
                return true;
            }
            if (this.presets[2] && oreName.contains("log")) {
                return true;
            }
            if (this.presets[3] && oreName.contains("plank")) {
                return true;
            }
            if (this.presets[4] && oreName.contains("dust")) {
                return true;
            }
            if (this.presets[5] && oreName.contains("crushed") && !oreName.contains("purified")) {
                return true;
            }
            if (this.presets[6] && oreName.contains("purified")) {
                return true;
            }
            if (this.presets[7] && oreName.contains("plate")) {
                return true;
            }
            if (this.presets[8] && oreName.contains("gem")) {
                return true;
            }
            if (this.presets[10] && oreName.contains("dye")) {
                return true;
            }
            if (!this.presets[11] || !oreName.contains("nugget")) continue;
            return true;
        }
        if (this.presets[9] && itemStack.func_77973_b() instanceof ItemFood) {
            return true;
        }
        if (this.presets[12] && itemStack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)itemStack.func_77973_b()) instanceof IPlantable) {
            return true;
        }
        return this.presets[13] && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        byte[] byteArray = new byte[this.presets.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = (byte)(this.presets[i] ? 1 : 0);
        }
        compound.func_74773_a("activePresets", byteArray);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        byte[] byteArray = compound.func_74770_j("activePresets");
        for (int i = 0; i < byteArray.length; ++i) {
            this.presets[i] = byteArray[i] == 1;
        }
    }

    @Override
    public void sendUpdate(EntityPlayerMP playerMP) {
        this.getParentFilter().sendBooleanArrayToPlayer(this, playerMP, 0, this.presets);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiWidgetWrapped getGuiWidget(int x, int y, int width, int height) {
        return new GuiFilterList(x, y, width, height, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIconSheet() {
        if (iconTexture == null) {
            iconTexture = SharedAtlas.findRegion("icon_filter_preset");
        }
        return PresetFilter.iconTexture.texture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconX() {
        return iconTexture.getRegionX();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconY() {
        return iconTexture.getRegionY();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconWidth() {
        return iconTexture.getRegionWidth();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconHeight() {
        return iconTexture.getRegionHeight();
    }

    @Override
    public void setFilterBooleanArray(int optionId, boolean[] values) {
        this.presets = values;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void setFilterBoolean(int optionId, boolean value) {
        this.presets[optionId] = value;
    }

    @Override
    public String getName(int index) {
        switch (index) {
            case 0: {
                return StatCollector.func_74838_a((String)Strings.INGOT_FILTER);
            }
            case 1: {
                return StatCollector.func_74838_a((String)Strings.ORE_FILTER);
            }
            case 2: {
                return StatCollector.func_74838_a((String)Strings.LOG_FILTER);
            }
            case 3: {
                return StatCollector.func_74838_a((String)Strings.PLANK_FILTER);
            }
            case 4: {
                return StatCollector.func_74838_a((String)Strings.DUST_FILTER);
            }
            case 5: {
                return StatCollector.func_74838_a((String)Strings.CRUSHED_ORE_FILTER);
            }
            case 6: {
                return StatCollector.func_74838_a((String)Strings.PURIFIED_ORE_FILTER);
            }
            case 7: {
                return StatCollector.func_74838_a((String)Strings.PLATE_FILTER);
            }
            case 8: {
                return StatCollector.func_74838_a((String)Strings.GEM_FILTER);
            }
            case 9: {
                return StatCollector.func_74838_a((String)Strings.FOOD_FILTER);
            }
            case 10: {
                return StatCollector.func_74838_a((String)Strings.DYE_FILTER);
            }
            case 11: {
                return StatCollector.func_74838_a((String)Strings.NUGGET_FILTER);
            }
            case 12: {
                return StatCollector.func_74838_a((String)Strings.PLANT_FILTER);
            }
            case 13: {
                return StatCollector.func_74838_a((String)Strings.FUEL_FILTER);
            }
        }
        return null;
    }

    @Override
    public void setValue(int optionIndex, boolean value) {
        this.presets[optionIndex] = value;
        this.markDirty(true);
    }

    @Override
    public boolean getValue(int optionIndex) {
        return this.presets[optionIndex];
    }

    @Override
    public int getOptionCount() {
        return this.presets.length;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getNameLangKey() {
        return Strings.PRESET_FILTER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDescriptionLangKey() {
        return Strings.PRESET_FILTER_DESCRIPTION;
    }
}

