/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.filter;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IMultiFilterChild;
import com.dynious.refinedrelocation.grid.filter.CreativeTabFilter;
import com.dynious.refinedrelocation.grid.filter.CustomRegexFilter;
import com.dynious.refinedrelocation.grid.filter.CustomUserFilter;
import com.dynious.refinedrelocation.grid.filter.ModFilter;
import com.dynious.refinedrelocation.grid.filter.PresetFilter;
import com.dynious.refinedrelocation.grid.filter.SameItemFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiFilterRegistry {
    private static Map<String, Class<? extends IMultiFilterChild>> filters = new HashMap<String, Class<? extends IMultiFilterChild>>();

    public static void add(String identifier, Class<? extends IMultiFilterChild> clazz) throws IllegalArgumentException {
        if (identifier == null || identifier.isEmpty() || clazz == null) {
            throw new IllegalArgumentException("Parameter is null or empty");
        }
        if (MultiFilterRegistry.contains(identifier)) {
            throw new IllegalArgumentException("Identifier already registered");
        }
        filters.put(identifier, clazz);
    }

    public static boolean contains(String identifier) {
        return filters.containsKey(identifier);
    }

    public static IMultiFilterChild getFilter(String identifier) {
        if (filters.containsKey(identifier)) {
            try {
                return filters.get(identifier).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getIdentifier(Class<? extends IMultiFilterChild> clazz) {
        for (Map.Entry<String, Class<? extends IMultiFilterChild>> e : filters.entrySet()) {
            if (!e.getValue().equals(clazz)) continue;
            return e.getKey();
        }
        return "";
    }

    public static void registerFilters() {
        APIUtils.registerMultiFilterChild("creative", CreativeTabFilter.class);
        APIUtils.registerMultiFilterChild("preset", PresetFilter.class);
        APIUtils.registerMultiFilterChild("user", CustomUserFilter.class);
        APIUtils.registerMultiFilterChild("regex", CustomRegexFilter.class);
        APIUtils.registerMultiFilterChild("sameItem", SameItemFilter.class);
        APIUtils.registerMultiFilterChild("mod", ModFilter.class);
    }

    public static Collection<Class<? extends IMultiFilterChild>> getFilters() {
        return filters.values();
    }
}

