/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.container;

import com.dynious.refinedrelocation.container.ContainerRefinedRelocation;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.network.packet.gui.MessageGUIBoolean;
import com.dynious.refinedrelocation.network.packet.gui.MessageGUIBooleanArray;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;

public class ContainerPowerLimiter
extends ContainerRefinedRelocation {
    private final TilePowerLimiter tile;
    private boolean initialUpdate = true;
    private boolean redstoneToggle;
    private boolean[] energyTypes = new boolean[EnergyType.values().length];

    public ContainerPowerLimiter(TilePowerLimiter tile) {
        this.tile = tile;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void setMaxAcceptedEnergy(double amount) {
        this.tile.setMaxAcceptedEnergy(amount);
    }

    public void setRedstoneToggle(boolean toggle) {
        this.tile.setRedstoneToggle(toggle);
    }

    public boolean[] getEnergyTypes() {
        return this.energyTypes;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.tile.getRedstoneToggle() != this.redstoneToggle || this.initialUpdate) {
            this.sendSyncMessage(new MessageGUIBoolean(7, this.tile.getRedstoneToggle()));
            this.redstoneToggle = this.tile.getRedstoneToggle();
        }
        boolean[] newEnergyTypes = new boolean[this.energyTypes.length];
        for (EnergyType energyType : this.tile.getConnectionTypes()) {
            newEnergyTypes[energyType.ordinal()] = true;
        }
        if (this.initialUpdate || !Arrays.equals(this.energyTypes, newEnergyTypes)) {
            this.sendSyncMessage(new MessageGUIBooleanArray(10, newEnergyTypes));
            for (int i = 0; i < this.energyTypes.length; ++i) {
                this.energyTypes[i] = newEnergyTypes[i];
            }
        }
        this.initialUpdate = false;
    }

    @Override
    public void onMessageDouble(int messageId, double value, EntityPlayer player, Side side) {
        if (ContainerPowerLimiter.isRestrictedAccessWithError(player)) {
            return;
        }
        if (messageId == 8) {
            this.setMaxAcceptedEnergy(value);
        }
    }

    @Override
    public void onMessageBoolean(int messageId, boolean value, EntityPlayer player, Side side) {
        if (ContainerPowerLimiter.isRestrictedAccessWithError(player)) {
            return;
        }
        if (messageId == 7) {
            this.setRedstoneToggle(value);
        }
    }

    @Override
    public void onMessageBooleanArray(int messageId, boolean[] values, EntityPlayer player, Side side) {
        if (ContainerPowerLimiter.isRestrictedAccessWithError(player)) {
            return;
        }
        if (messageId == 10) {
            this.energyTypes = values;
        }
    }
}

