/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.renderer;

import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.repack.codechicken.lib.lighting.LightModel;
import com.dynious.refinedrelocation.repack.codechicken.lib.render.CCModel;
import com.dynious.refinedrelocation.repack.codechicken.lib.render.CCRenderState;
import com.dynious.refinedrelocation.repack.codechicken.lib.render.TextureUtils;
import com.dynious.refinedrelocation.repack.codechicken.lib.render.uv.IconTransformation;
import com.dynious.refinedrelocation.repack.codechicken.lib.vec.Translation;
import com.dynious.refinedrelocation.repack.codechicken.lib.vec.Vector3;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class RendererRelocator
extends TileEntitySpecialRenderer {
    public static final CCModel CENTER_MODEL;
    public static final CCModel[] SIDE_MODELS;
    public static RendererRelocator instance;
    public static IIcon[] iconsCenter;
    public static IIcon iconSide;
    public static IIcon iconSideStuffed;
    private static RenderItem renderer;
    private static EntityItem entityItem;
    private static IconTransformation iconTransformation;

    public static void resetRenderer() {
        CCRenderState.reset();
        CCRenderState.setDynamic();
    }

    public static void loadIcons(IIconRegister register) {
        RendererRelocator.iconsCenter[0] = register.func_94245_a(Resources.MOD_ID + ":relocatorCenter0");
        RendererRelocator.iconsCenter[1] = register.func_94245_a(Resources.MOD_ID + ":relocatorCenter1");
        RendererRelocator.iconsCenter[2] = register.func_94245_a(Resources.MOD_ID + ":relocatorCenter2");
        RendererRelocator.iconsCenter[3] = register.func_94245_a(Resources.MOD_ID + ":relocatorCenter3");
        iconSide = register.func_94245_a(Resources.MOD_ID + ":relocatorSide");
        iconSideStuffed = register.func_94245_a(Resources.MOD_ID + ":relocatorSideStuffed");
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        IRelocator relocator = (IRelocator)tile;
        GL11.glPushMatrix();
        TextureUtils.bindAtlas(0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RendererRelocator.resetRenderer();
        GL11.glPushMatrix();
        CCRenderState.startDrawing();
        Translation trans = new Translation(x + 0.5, y + 0.5, z + 0.5);
        for (int side = 0; side < 6; ++side) {
            if (relocator.connectsToSide(side)) {
                IRelocatorModule module = relocator.getRelocatorModule(side);
                if (module != null) {
                    RendererRelocator.iconTransformation.icon = module.getIcon(relocator, side);
                    SIDE_MODELS[side].render(0, 4, trans, iconTransformation);
                    SIDE_MODELS[side].render(8, 24, trans, iconTransformation);
                    SIDE_MODELS[side].render(24, 28, trans, iconTransformation);
                    SIDE_MODELS[side].render(32, 48, trans, iconTransformation);
                }
                RendererRelocator.iconTransformation.icon = relocator.isStuffedOnSide(side) ? iconSideStuffed : iconSide;
                SIDE_MODELS[side].render(0, 4, trans, iconTransformation);
                SIDE_MODELS[side].render(8, 24, trans, iconTransformation);
                SIDE_MODELS[side].render(24, 28, trans, iconTransformation);
                SIDE_MODELS[side].render(32, 48, trans, iconTransformation);
                continue;
            }
            switch (relocator.getRenderType()) {
                case 0: {
                    RendererRelocator.iconTransformation.icon = iconsCenter[0];
                    break;
                }
                case 1: {
                    RendererRelocator.iconTransformation.icon = iconsCenter[1];
                    break;
                }
                case 2: {
                    RendererRelocator.iconTransformation.icon = iconsCenter[2];
                    break;
                }
                case 3: {
                    RendererRelocator.iconTransformation.icon = iconsCenter[3];
                }
            }
            CENTER_MODEL.render(side * 4, side * 4 + 4, trans, iconTransformation);
            CENTER_MODEL.render(24 + side * 4, 24 + side * 4 + 4, trans, iconTransformation);
        }
        CCRenderState.draw();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        for (TravellingItem item : relocator.getItems(false)) {
            if (item.getItemStack() == null) continue;
            GL11.glPushMatrix();
            entityItem.func_92058_a(item.getItemStack());
            float progress = item.getClientSideProgress(partialTick);
            GL11.glTranslated((double)item.getX(progress), (double)item.getY(progress), (double)item.getZ(progress));
            renderer.func_76986_a(entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    static {
        SIDE_MODELS = new CCModel[6];
        instance = new RendererRelocator();
        iconsCenter = new IIcon[4];
        entityItem = new EntityItem(null);
        iconTransformation = new IconTransformation(Blocks.field_150348_b.func_149691_a(0, 0));
        renderer = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        renderer.func_76976_a(RenderManager.field_78727_a);
        RendererRelocator.entityItem.field_70290_d = 0.0f;
        CENTER_MODEL = CCModel.quadModel(48).generateBox(0, -4.0, -4.0, -4.0, 8.0, 8.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        CCModel.generateBackface(CENTER_MODEL, 0, CENTER_MODEL, 24, 24);
        CENTER_MODEL.computeNormals().computeLighting(LightModel.standardLightModel);
        RendererRelocator.SIDE_MODELS[1] = CCModel.quadModel(48).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        CCModel.generateBackface(SIDE_MODELS[1], 0, SIDE_MODELS[1], 24, 24);
        CCModel.generateSidedModels(SIDE_MODELS, 1, new Vector3());
        for (CCModel model : SIDE_MODELS) {
            model.computeNormals().computeLighting(LightModel.standardLightModel);
        }
    }
}

