/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.client.gui.GuiRefinedRelocationContainer;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonPriority
extends GuiButton {
    private ISortingInventory tile;

    public GuiButtonPriority(IGuiParent parent, int x, int y, ISortingInventory tile) {
        super(parent, x, y, "");
        this.tile = tile;
        this.setAdventureModeRestriction(true);
    }

    public void setValue(ISortingInventory.Priority priority) {
        String text = "";
        switch (priority) {
            case HIGH: {
                text = "+";
                break;
            }
            case NORMAL_HIGH: {
                text = "0+";
                break;
            }
            case NORMAL: {
                text = "0";
                break;
            }
            case NORMAL_LOW: {
                text = "-0";
                break;
            }
            case LOW: {
                text = "-";
            }
        }
        this.label.setText(text);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)Strings.PRIORITY) + ":");
            tooltip.add("\u00a77" + StatCollector.func_74838_a((String)this.tile.getPriority().name().replace('_', '-')));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_INCREASE));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_DECREASE));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (!(!this.isInsideBounds(mouseX, mouseY) || type != 0 && type != 1 || this.isAdventureModeRestriction() && GuiRefinedRelocationContainer.isRestrictedAccessWithError())) {
            int amount;
            int n = amount = type == 0 ? -1 : 1;
            if (this.tile.getPriority().ordinal() + amount >= 0 && this.tile.getPriority().ordinal() + amount < ISortingInventory.Priority.values().length) {
                ISortingInventory.Priority newPriority = ISortingInventory.Priority.values()[this.tile.getPriority().ordinal() + amount];
                this.tile.setPriority(newPriority);
                GuiHelper.sendByteMessage(6, (byte)newPriority.ordinal());
                this.setValue(newPriority);
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getPriority());
        }
        super.update();
    }
}

