/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonCounter;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonMaxStackSize
extends GuiButtonCounter {
    protected IAdvancedTile tile;

    public GuiButtonMaxStackSize(IGuiParent parent, int x, int y, IAdvancedTile tile) {
        super(parent, x, y, 24, 20, 0, 64, 1, 16);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.tile == null) {
            return;
        }
        this.tile.setMaxStackSize((byte)newValue);
        GuiHelper.sendByteMessage(2, (byte)newValue);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)Strings.MAX_STACK_SIZE));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_INCREASE));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_DECREASE));
        }
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getMaxStackSize());
        }
        super.update();
    }
}

