/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleSneakyExtraction;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiButtonExtractionSide
extends GuiButton {
    private RelocatorModuleSneakyExtraction module;

    public GuiButtonExtractionSide(IGuiParent parent, int x, int y, RelocatorModuleSneakyExtraction module) {
        super(parent, x, y, 34, 20, "button_large", ForgeDirection.getOrientation((int)module.getExtractionSide()).toString());
        this.module = module;
        this.setTooltipString(StatCollector.func_74838_a((String)Strings.SNEAKY));
        this.setAdventureModeRestriction(true);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isInsideBounds(mouseX, mouseY)) {
            if (type == 0) {
                this.onValueChangedByUser((this.module.getExtractionSide() + 1) % ForgeDirection.VALID_DIRECTIONS.length);
            } else if (type == 1) {
                int i = this.module.getExtractionSide() - 1;
                if (i < 0) {
                    i = ForgeDirection.VALID_DIRECTIONS.length - 1;
                }
                this.onValueChangedByUser(i);
            }
        }
    }

    protected void onValueChangedByUser(int side) {
        this.module.setExtractionSide(side);
        GuiHelper.sendIntMessage(3, side);
    }

    @Override
    public void update() {
        if (this.module != null) {
            ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.module.getExtractionSide());
            this.label.setText(outputDirection.toString());
            int[] blockInfo = this.getSneakySideBlockInfo();
            String blockName = BlockHelper.getBlockDisplayName((World)Minecraft.func_71410_x().field_71441_e, blockInfo[0], blockInfo[1], blockInfo[2], ForgeDirection.getOrientation((int)blockInfo[3]));
            this.setTooltipString(blockName + "\n" + StatCollector.func_74838_a((String)Strings.SNEAKY_EXTRACTION));
        }
        super.update();
    }

    private int[] getSneakySideBlockInfo() {
        TileRelocator relocator = this.module.getRelocator();
        ForgeDirection direction = this.module.getSide();
        ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.module.getExtractionSide());
        return new int[]{relocator.field_145851_c + direction.offsetX + outputDirection.offsetX, relocator.field_145848_d + direction.offsetY + outputDirection.offsetY, relocator.field_145849_e + direction.offsetZ + outputDirection.offsetZ, direction.ordinal()};
    }
}

