/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.GuiRefinedRelocationContainer;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.lib.Strings;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonCounter
extends GuiButton {
    public DecimalFormat numberFormat = new DecimalFormat("##.##");
    protected double value;
    protected double min;
    protected double max;
    protected double step;
    protected double shiftStep;

    public GuiButtonCounter(IGuiParent parent, int x, int y, int w, int h, int min, int max, int step, int shiftStep) {
        super(parent, x, y, w, h, "button", "");
        this.min = min;
        this.max = max;
        this.step = step;
        this.shiftStep = shiftStep;
        this.setValue(min);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = Math.max(this.min, Math.min(this.max, value));
        this.label.setText(this.numberFormat.format(this.getValue()));
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add("\u00a77" + StatCollector.func_74838_a((String)Strings.CLICK) + ": \u00b1" + this.numberFormat.format(this.step));
            tooltip.add("\u00a77" + StatCollector.func_74838_a((String)Strings.SHIFT_CLICK) + ": \u00b1" + this.numberFormat.format(this.shiftStep));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (!(!this.isInsideBounds(mouseX, mouseY) || type != 0 && type != 1 || this.isAdventureModeRestriction() && GuiRefinedRelocationContainer.isRestrictedAccessWithError())) {
            double oldVal = this.getValue();
            double curStep = (isShiftKeyDown ? this.shiftStep : this.step) * (double)(type == 1 ? -1 : 1);
            this.setValue(this.getValue() + curStep);
            if (oldVal != this.getValue()) {
                this.onValueChangedByUser(this.getValue());
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    protected void onValueChangedByUser(double newValue) {
    }
}

