/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.GuiFiltered;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonToggle;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.filter.MessageSetFilterBlacklist;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonBlacklist
extends GuiButtonToggle {
    private final GuiFiltered parent;

    public GuiButtonBlacklist(GuiFiltered parent, int x, int y) {
        super(parent, x, y, 16, 16, "button_whitelist_small", "button_blacklist_small", null, null);
        this.parent = parent;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        int selectedFilterIndex = this.parent.getSelectedFilterIndex();
        if (selectedFilterIndex != -1) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetFilterBlacklist(selectedFilterIndex, newState));
        }
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            String[] tooltipLines;
            tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.BLACKLIST : Strings.WHITELIST)));
            for (String tooltipLine : tooltipLines = StatCollector.func_74838_a((String)(this.getState() ? Strings.BLACKLIST_DESC : Strings.WHITELIST_DESC)).split("\\\\n")) {
                tooltip.add("\u00a77" + tooltipLine);
            }
            tooltip.add("\u00a7b" + StatCollector.func_74838_a((String)Strings.FILTER_ORDER));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
        }
    }

    @Override
    public void update() {
        int selectedFilterIndex = this.parent.getSelectedFilterIndex();
        if (selectedFilterIndex >= 0 && selectedFilterIndex < this.parent.getFilter().getFilterCount()) {
            this.setState(this.parent.getFilter().getFilterAtIndex(this.parent.getSelectedFilterIndex()).isBlacklist());
        }
        super.update();
    }

    @Override
    public boolean isInsideBounds(int x, int y) {
        return this.parent.hasFilterSelected() && super.isInsideBounds(x, y);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        if (this.parent.hasFilterSelected()) {
            super.drawBackground(mouseX, mouseY);
        }
    }
}

