/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.IGuiWidgetBase;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiTabPanel;
import com.dynious.refinedrelocation.client.gui.widget.GuiWidgetBase;
import org.lwjgl.opengl.GL11;

public class GuiTabButton
extends GuiWidgetBase {
    private final GuiTabPanel panel;
    private final int tabIndex;
    private final IGuiWidgetBase page;
    private final TextureRegion[] textureTab = new TextureRegion[2];
    private final TextureRegion textureIcon;
    private boolean active;

    public GuiTabButton(IGuiParent parent, GuiTabPanel panel, int x, int y, IGuiWidgetBase page, int tabIndex, TextureRegion textureIcon) {
        super(parent, x, y, 31, 26);
        this.panel = panel;
        this.page = page;
        this.tabIndex = tabIndex;
        this.textureIcon = textureIcon;
        this.textureTab[0] = SharedAtlas.findRegion("tab_inactive_slot");
        this.textureTab[1] = SharedAtlas.findRegion("tab_active_slot");
    }

    public void setPlainTexture() {
        this.textureTab[0] = SharedAtlas.findRegion("tab_inactive");
        this.textureTab[1] = SharedAtlas.findRegion("tab_active");
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        if (this.isInsideBounds(mouseX, mouseY)) {
            this.setActive(true);
        }
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            this.panel.setCurrentPage(this.page);
            this.panel.setActiveTabButton(this);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.textureTab[this.active ? 1 : 0].draw(this.x + (this.active ? 2 : 0), this.y);
        if (this.textureIcon != null) {
            this.textureIcon.draw(this.x + 17 + (this.active ? 2 : 0) - this.textureIcon.getRegionWidth() / 2, this.y + this.h / 2 - this.textureIcon.getRegionHeight() / 2);
        }
    }

    public IGuiWidgetBase getTabPage() {
        return this.page;
    }
}

