/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.block;

import cofh.api.block.IDismantleable;
import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.client.renderer.DirectionalRenderer;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.block.IDismantleable", modid="CoFHAPI|block")
public class BlockPowerLimiter
extends BlockContainer
implements IDismantleable {
    private final IIcon[] icons = new IIcon[3];
    private final IIcon[] iconsDisabled = new IIcon[3];

    public BlockPowerLimiter() {
        super(Material.field_151576_e);
        this.func_149663_c("powerLimiter");
        this.func_149711_c(3.0f);
        this.func_149647_a(RefinedRelocation.tabRefinedRelocation);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePowerLimiter();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            TilePowerLimiter tile = (TilePowerLimiter)world.func_147438_o(x, y, z);
            if (player.func_70093_af()) {
                tile.setDisablePower(!tile.getDisablePower());
                return true;
            }
            GuiHelper.openGui(player, tile);
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        super.func_149695_a(world, x, y, z, par5);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TilePowerLimiter) {
            ((TilePowerLimiter)tile).blocksChanged = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "powerLimiter" + "Front");
        this.icons[1] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "powerLimiter" + "Back");
        this.icons[2] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "powerLimiter" + "Side");
        this.iconsDisabled[0] = this.icons[0];
        this.iconsDisabled[1] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "powerLimiter" + "BackDisabled");
        this.iconsDisabled[2] = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "powerLimiter" + "SideDisabled");
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.icons[1];
    }

    public IIcon func_149673_e(IBlockAccess worldObj, int x, int y, int z, int side) {
        TilePowerLimiter tile = (TilePowerLimiter)worldObj.func_147438_o(x, y, z);
        IIcon[] icons = this.icons;
        if (tile.getDisablePower()) {
            icons = this.iconsDisabled;
        }
        int sideIdx = tile.getConnectedDirection().ordinal() == side ? 0 : (tile.getConnectedDirection().getOpposite().ordinal() == side ? 1 : 2);
        return icons[sideIdx];
    }

    public int func_149645_b() {
        return DirectionalRenderer.renderId;
    }

    @Optional.Method(modid="CoFHAPI|block")
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        int meta = world.func_72805_g(x, y, z);
        ArrayList items = this.getDrops(world, x, y, z, meta, 0);
        for (ItemStack item : items) {
            IOHelper.spawnItemInWorld(world, item, x, y, z);
        }
        world.func_147468_f(x, y, z);
        return null;
    }

    @Optional.Method(modid="CoFHAPI|block")
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TilePowerLimiter tile = (TilePowerLimiter)worldObj.func_147438_o(x, y, z);
        return tile.rotateBlock();
    }
}

